/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TeleportUtils;

public class Helper {
    public static final Random random = new Random();
    @Nullable
    public static Boolean isHalloween = null;
    public static boolean isContributor = false;
    public static ContributorStore CONTRIBUTORS = ContributorStore.of();
    public static List<Perk> DISABLED_PERKS = new ArrayList<Perk>();

    public static boolean isContributor(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return isContributor;
        }
        return CONTRIBUTORS.contains(player);
    }

    public static boolean isDisabledPerk(EntityPlayer player, @Nullable Perk perk) {
        if (player.field_70170_p.field_72995_K) {
            return DISABLED_PERKS.contains(perk);
        }
        return perk == null || perk.isDisabled();
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    public static String dump(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static boolean existClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> List<T> iterableToList(Iterable<T> it) {
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return list;
    }

    public static int getDimensionId(IWorld world) {
        return world.func_201675_m().func_186058_p().func_186068_a();
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !World.func_189509_E((BlockPos)pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !World.func_189509_E((BlockPos)pos);
    }

    public static boolean isValidDimension(int dim) {
        return Helper.getDimensionIds().contains(dim);
    }

    public static List<Integer> getDimensionIds() {
        return DimensionManager.getRegistry().func_201756_e().map(DimensionType::func_186068_a).collect(Collectors.toList());
    }

    public static List<String> getDimensionIdsAsStringList() {
        return Helper.getDimensionIds().stream().map(Object::toString).collect(Collectors.toList());
    }

    public static void grantAdvancement(EntityPlayer playerIn, String name, String ... criterias) {
        AdvancementProgress advancementprogress;
        AdvancementManager am;
        Advancement advancement;
        EntityPlayerMP player;
        MinecraftServer server;
        if (EntityHelper.isValidPlayerMP((Entity)playerIn) && (server = (player = (EntityPlayerMP)playerIn).func_184102_h()) != null && (advancement = (am = server.func_191949_aK()).func_192778_a(new ResourceLocation("tombstone", name))) != null && !(advancementprogress = player.func_192039_O().func_192747_a(advancement)).func_192105_a()) {
            List usedCriterias = StreamSupport.stream(advancementprogress.func_192107_d().spliterator(), false).filter(p -> criterias.length == 0 || Arrays.asList(criterias).contains(p)).collect(Collectors.toList());
            for (String criteria : usedCriterias) {
                player.func_192039_O().func_192750_a(advancement, criteria);
            }
        }
    }

    public static Location findNearestStructure(WorldServer world, BlockPos pos, SupportStructures struct, boolean unexplored) {
        BlockPos startingPos = pos;
        for (int nbTry = 0; nbTry < 10; ++nbTry) {
            BlockPos foundPos;
            if (nbTry > 3) {
                startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177982_a(Helper.getRandom(-nbTry * 500, nbTry * 500), 0, Helper.getRandom(-nbTry * 500, nbTry * 500)));
            }
            if ((foundPos = world.func_211157_a(struct.getStructureName(), startingPos, 500, unexplored)) == null || !World.func_175701_a((BlockPos)foundPos)) continue;
            Location structureLoc = new Location(foundPos, (IWorld)world);
            if (struct == SupportStructures.VILLAGE && unexplored && Helper.isVillageExplored((World)world, structureLoc.getPos())) continue;
            return structureLoc;
        }
        return Location.ORIGIN;
    }

    public static boolean isVillageExplored(World world, BlockPos villagePos) {
        return world.func_175714_ae().func_75540_b().stream().anyMatch(v -> v.func_180608_a().equals((Object)villagePos));
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (!(blockpos.func_177956_o() < 0 || (state = chunk.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c() && state.func_185904_a() != Material.field_151584_j)) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public static Location findSpawnForVillage(WorldServer world, BlockPos villagePos) {
        return new SpawnHelper(world, Helper.getTopSolidOrLiquidBlock((World)world, villagePos)).findSpawnPlace();
    }

    public static <T extends Entity> T teleportEntity(T entity, Location loc) {
        return (T)TeleportUtils.teleportEntity(entity, loc.dim, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5);
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc) {
        return Helper.teleportEntity(entity, new Location(loc.getPos().func_177984_a(), loc.dim));
    }

    public static boolean isRuleKeepInventory(EntityPlayer player) {
        return Helper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_82766_b("keepInventory");
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        Helper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)ConfigTombstone.general.gravesBypassGriefingRules.get()).booleanValue()) {
            world.func_180501_a(pos, state, 3);
            return;
        }
        Chunk chunk = world.func_175726_f(pos);
        ChunkSection[] storageArray = chunk.func_76587_i();
        ChunkSection storage = storageArray[pos.func_177956_o() >> 4];
        if (storage == null) {
            ChunkSection chunkSection = new ChunkSection(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
            storageArray[pos.func_177956_o() >> 4] = chunkSection;
            storage = chunkSection;
        }
        chunk.func_76630_e();
        IBlockState oldState = storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
        if (state.func_200016_a((IBlockReader)world, pos) != oldState.func_200016_a((IBlockReader)world, pos) || state.getLightValue((IWorldReader)world, pos) != oldState.getLightValue((IWorldReader)world, pos)) {
            world.func_175664_x(pos);
        }
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, state, 3);
    }

    public static boolean canShowTooltip(ItemStack stack) {
        return (Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != false || GuiScreen.func_146272_n();
    }

    public static boolean isDateAroundHalloween() {
        return isHalloween != null && isHalloween != false;
    }

    public static boolean isDateAroundHalloween(LocalDate date) {
        if (isHalloween == null) {
            isHalloween = (Boolean)ConfigTombstone.general.persistantHalloween.get() != false || date.get(ChronoField.MONTH_OF_YEAR) + 1 == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) + 1 == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3;
        }
        return isHalloween;
    }

    public static boolean isNight(World world) {
        return world.func_72826_c(0.0f) >= 0.245f && world.func_72826_c(0.0f) <= 0.755f;
    }

    public static void addRandomPotion(EntityPlayer player, int duration, boolean withMessage) {
        Potion potion;
        List potions = ForgeRegistries.POTIONS.getValues().stream().filter(p -> {
            if (p == null) {
                return false;
            }
            assert (p.getRegistryName() != null);
            return !p.func_76398_f() && !((List)ConfigTombstone.general.blackListEffects.get()).contains(p.getRegistryName().toString());
        }).collect(Collectors.toList());
        if (potions.size() > 0 && (potion = (Potion)potions.get(Helper.getRandom(0, potions.size() - 1))) != null) {
            int level;
            int random = Helper.getRandom(1, 100);
            int n = random < 10 ? 4 : (random < 25 ? 3 : (random < 45 ? 2 : (level = random < 70 ? 1 : 0)));
            if (withMessage && !potion.func_76393_a().isEmpty()) {
                player.func_145747_a(LangKey.MESSAGE_SPELL_CAST_ON_YOU.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new TextComponentTranslation(potion.func_76393_a(), new Object[0]).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle())));
            }
            EntityHelper.addPotion((EntityLivingBase)player, potion, duration, level, new boolean[0]);
        }
    }

    public static float[] getRGBColorF(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }
}

