/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import ovh.corail.tombstone.helper.Location;

public class NBTStackHelper {
    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        stack.func_196082_o().func_74778_a(keyName, keyValue);
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 8)) {
            return tag.func_74779_i(keyName);
        }
        return "";
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        stack.func_196082_o().func_74757_a(keyName, keyValue);
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 1)) {
            return tag.func_74767_n(keyName);
        }
        return false;
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        stack.func_196082_o().func_74768_a(keyName, keyValue);
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 3)) {
            return tag.func_74762_e(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        stack.func_196082_o().func_74772_a(keyName, keyValue);
        return stack;
    }

    public static long getLong(ItemStack stack, String keyName) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 4)) {
            return tag.func_74763_f(keyName);
        }
        return Long.MIN_VALUE;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setInteger(stack, keyName + "X", keyValue.func_177958_n());
        NBTStackHelper.setInteger(stack, keyName + "Y", keyValue.func_177956_o());
        NBTStackHelper.setInteger(stack, keyName + "Z", keyValue.func_177952_p());
        return stack;
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        int intValueX = NBTStackHelper.getInteger(stack, keyName + "X");
        int intValueY = NBTStackHelper.getInteger(stack, keyName + "Y");
        int intValueZ = NBTStackHelper.getInteger(stack, keyName + "Z");
        return intValueX != Integer.MIN_VALUE && intValueY != Integer.MIN_VALUE && intValueZ != Integer.MIN_VALUE ? new BlockPos(intValueX, intValueY, intValueZ) : BlockPos.field_177992_a;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location position) {
        NBTStackHelper.setBlockPos(stack, keyName, position.getPos());
        NBTStackHelper.setInteger(stack, keyName + "D", position.dim);
        return stack;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        BlockPos pos = NBTStackHelper.getBlockPos(stack, keyName);
        int dim = NBTStackHelper.getInteger(stack, keyName + "D");
        return pos.equals((Object)BlockPos.field_177992_a) || dim == Integer.MIN_VALUE ? Location.ORIGIN : new Location(pos, dim);
    }

    public static boolean hasKeyName(ItemStack stack, String keyName) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b(keyName);
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        NBTTagCompound tag = stack.func_77978_p();
        boolean removed = false;
        if (tag != null && tag.func_74764_b(keyName)) {
            removed = true;
            tag.func_82580_o(keyName);
            if (tag.isEmpty()) {
                stack.func_77982_d(null);
            }
        }
        return removed;
    }
}

