/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class VillageSiegeHandler {
    public static final VillageSiegeHandler instance = new VillageSiegeHandler();

    public static void sendDevLog(String message) {
        if (((Boolean)ConfigTombstone.village_siege.logSiegeState.get()).booleanValue()) {
            ModTombstone.LOGGER.info(message);
        }
    }

    private VillageSiegeHandler() {
    }

    public void checkWorld(WorldServer world) {
        if (((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue() && !(world.field_175740_d instanceof CustomVillageSiege)) {
            try {
                world.field_175740_d = new CustomVillageSiege(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class CustomVillageSiege
    extends VillageSiege {
        public final boolean isRejectedDim;
        public final WorldServer field_75537_a;
        public SiegeState field_75536_c;
        public boolean hasFailedTrySiege;
        public Village field_75531_f;
        public int field_75534_e;
        public int field_75533_d;
        public int field_75532_g;
        public int field_75538_h;
        public int field_75539_i;

        public CustomVillageSiege(WorldServer world) {
            super(null);
            this.field_75536_c = SiegeState.INIT;
            this.hasFailedTrySiege = false;
            this.field_75534_e = 0;
            this.field_75533_d = 0;
            this.field_75537_a = world;
            ResourceLocation registryName = DimensionType.func_212678_a((DimensionType)world.func_201675_m().getDimension().func_186058_p());
            this.isRejectedDim = registryName == null || ((List)ConfigTombstone.village_siege.deniedDimensionTypeForSiege.get()).contains(registryName.toString());
        }

        public void func_75528_a() {
            if (this.isRejectedDim) {
                return;
            }
            if (this.field_75537_a.func_72935_r()) {
                this.field_75536_c = SiegeState.DAY_TIME;
                this.hasFailedTrySiege = false;
            } else {
                if (this.field_75536_c == SiegeState.DAY_TIME) {
                    double angle = this.field_75537_a.func_72826_c(0.0f);
                    if (angle < 0.5 || angle > 0.501) {
                        return;
                    }
                    VillageSiegeHandler.sendDevLog("Launching a village siege");
                    this.field_75536_c = Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.village_siege.siegeChance.get() ? SiegeState.SIEGE_START : SiegeState.SIEGE_END;
                    VillageSiegeHandler.sendDevLog("Random chance : Siege " + (this.field_75536_c == SiegeState.SIEGE_START ? "started" : "aborted"));
                }
                if (this.field_75536_c == SiegeState.INIT || this.field_75536_c == SiegeState.SIEGE_END) {
                    return;
                }
                if (this.field_75536_c == SiegeState.SIEGE_START) {
                    if ((Integer)ConfigTombstone.village_siege.delaySiegeTest.get() > 0 && this.hasFailedTrySiege && !TimeHelper.atInterval(TimeHelper.worldTicks((World)this.field_75537_a), (Integer)ConfigTombstone.village_siege.delaySiegeTest.get())) {
                        return;
                    }
                    if (!this.trySetupSiege() || EventFactory.onVillageSiegeStart(this.field_75531_f, new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i))) {
                        this.hasFailedTrySiege = true;
                        VillageSiegeHandler.sendDevLog("Try to siege : failed");
                        return;
                    }
                    this.field_75536_c = SiegeState.SPAWN_MOBS;
                    VillageSiegeHandler.sendDevLog("Spawning " + ConfigTombstone.village_siege.siegeMaxCreature.get() + " zombie" + ((Integer)ConfigTombstone.village_siege.siegeMaxCreature.get() > 1 ? "s" : ""));
                }
                if (this.field_75536_c == SiegeState.SPAWN_MOBS) {
                    if (this.field_75534_e > 0) {
                        --this.field_75534_e;
                    } else {
                        this.field_75534_e = 2;
                        if (this.field_75533_d > 0) {
                            this.spawnZombie();
                            --this.field_75533_d;
                        } else {
                            this.field_75536_c = SiegeState.SIEGE_END;
                            VillageSiegeHandler.sendDevLog("Siege ended");
                        }
                    }
                }
            }
        }

        private boolean trySetupSiege() {
            List playerList = this.field_75537_a.field_73010_i;
            if (((Boolean)ConfigTombstone.village_siege.shufflePlayersForSiege.get()).booleanValue()) {
                Collections.shuffle(playerList, Helper.random);
            }
            Iterator it = playerList.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return false;
                }
                EntityPlayer player = (EntityPlayer)it.next();
                if (player.func_175149_v() || player.func_184812_l_() && !((Boolean)ConfigTombstone.village_siege.allowCreativePlayersForSiege.get()).booleanValue()) continue;
                this.field_75531_f = this.field_75537_a.func_175714_ae().func_176056_a(new BlockPos((Entity)player), 1);
                if (this.field_75531_f == null || this.field_75531_f.func_75567_c() < (Integer)ConfigTombstone.village_siege.siegeMinDoor.get() || this.field_75531_f.func_75561_d() < 20 || this.field_75531_f.func_75562_e() < (Integer)ConfigTombstone.village_siege.siegeMinVillager.get() || this.field_75531_f.field_75587_j < (Integer)ConfigTombstone.village_siege.siegeMinGolem.get()) continue;
                BlockPos blockpos = this.field_75531_f.func_180608_a();
                float r = this.field_75531_f.func_75568_b();
                boolean isNearOtherVillage = false;
                for (int i = 0; i < 10; ++i) {
                    float f1 = this.field_75537_a.field_73012_v.nextFloat() * ((float)Math.PI * 2);
                    this.field_75532_g = blockpos.func_177958_n() + (int)((double)(MathHelper.func_76134_b((float)f1) * r) * 0.9);
                    this.field_75538_h = blockpos.func_177956_o();
                    this.field_75539_i = blockpos.func_177952_p() + (int)((double)(MathHelper.func_76126_a((float)f1) * r) * 0.9);
                    isNearOtherVillage = this.field_75537_a.func_175714_ae().func_75540_b().stream().anyMatch(currentVillage -> currentVillage != this.field_75531_f && currentVillage.func_179866_a(new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i)));
                    if (!isNearOtherVillage) break;
                }
                if (isNearOtherVillage) {
                    return false;
                }
                Vec3d vec3d = this.findRandomSpawnPos(new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
                if (vec3d != null && !MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent((VillageSiege)this, (World)this.field_75537_a, player, this.field_75531_f, vec3d))) break;
            }
            this.field_75534_e = 0;
            this.field_75533_d = (Integer)ConfigTombstone.village_siege.siegeMaxCreature.get();
            return true;
        }

        private boolean spawnZombie() {
            EntityZombie mob;
            Vec3d vec3d = this.findRandomSpawnPos(new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
            if (vec3d == null) {
                return false;
            }
            try {
                mob = new EntityZombie((World)this.field_75537_a);
                mob.func_204210_a(this.field_75537_a.func_175649_E(new BlockPos((Entity)mob)), null, null);
                if (((Boolean)ConfigTombstone.village_siege.persistentMobInSiege.get()).booleanValue()) {
                    mob.func_110163_bv();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (((Boolean)ConfigTombstone.village_siege.undeadWearHelmInSiege.get()).booleanValue() && mob.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                EnumDifficulty difficulty = this.field_75537_a.func_175659_aa();
                mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((IItemProvider)(difficulty == EnumDifficulty.HARD ? Items.field_151161_ac : (difficulty == EnumDifficulty.NORMAL ? Items.field_151028_Y : Items.field_151024_Q))));
            }
            mob.func_70012_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_75537_a.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (EventFactory.onVillageSiegeZombieSpawn(this.field_75531_f, mob)) {
                return false;
            }
            this.field_75537_a.func_72838_d((Entity)mob);
            assert (this.field_75531_f != null);
            BlockPos villageCenter = this.field_75531_f.func_180608_a();
            mob.func_175449_a(villageCenter, this.field_75531_f.func_75568_b());
            if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                EntityHelper.addPotion((EntityLivingBase)mob, MobEffects.field_188423_x, 10000, 1, new boolean[0]);
            }
            return true;
        }

        @Nullable
        private Vec3d findRandomSpawnPos(BlockPos initPos) {
            for (int i = 0; i < 10; ++i) {
                BlockPos currentPos = initPos.func_177982_a(this.field_75537_a.field_73012_v.nextInt(16) - 8, this.field_75537_a.field_73012_v.nextInt(6) - 3, this.field_75537_a.field_73012_v.nextInt(16) - 8);
                if (!this.field_75531_f.func_179866_a(currentPos) || !this.canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.SpawnPlacementType.ON_GROUND, (World)this.field_75537_a, currentPos, null)) continue;
                return new Vec3d((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p());
            }
            return null;
        }

        public boolean canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.SpawnPlacementType spawnPlacementType, World world, BlockPos pos, @Nullable EntityType<? extends EntityLiving> entityType) {
            if (!world.func_175723_af().func_177746_a(pos)) {
                return false;
            }
            IBlockState iblockstate = world.func_180495_p(pos);
            if (spawnPlacementType == EntitySpawnPlacementRegistry.SpawnPlacementType.IN_WATER) {
                return iblockstate.func_185904_a() == Material.field_151586_h && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h && !world.func_180495_p(pos.func_177984_a()).func_185915_l();
            }
            BlockPos blockpos = pos.func_177977_b();
            IBlockState state = world.func_180495_p(blockpos);
            if (!state.func_177230_c().canCreatureSpawn(state, (IWorldReaderBase)world, blockpos, spawnPlacementType, entityType) || state.func_177230_c() instanceof BlockStairs) {
                return false;
            }
            Block block = world.func_180495_p(blockpos).func_177230_c();
            boolean flag = block != Blocks.field_150357_h && block != Blocks.field_180401_cv;
            return flag && this.isValidEmptySpawnBlock(iblockstate) && this.isValidEmptySpawnBlock(world.func_180495_p(pos.func_177984_a()));
        }

        public boolean isValidEmptySpawnBlock(IBlockState state) {
            return !state.func_185898_k() && !state.func_185897_m() && !state.func_185904_a().func_76224_d() && !BlockRailBase.func_208487_j((IBlockState)state);
        }
    }

    public static enum SiegeState {
        INIT,
        DAY_TIME,
        SIEGE_START,
        SIEGE_END,
        SPAWN_MOBS;

    }
}

