/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ISoulConsumer;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.registry.ModEffects;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer {
    public ItemAnkhOfPray() {
        super("ankh_of_pray", ItemAnkhOfPray.getBuilder(true).func_200917_a(1).func_200915_b(10));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(stack)) {
            list.add(new TextComponentTranslation("tombstone.item." + this.name + ".desc", new Object[0]).func_150255_a(StyleType.TOOLTIP_DESC.getStyle()));
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    long cd;
                    if (!cap.canPray((EntityPlayer)player) && (cd = (cap.getNextPray() - TimeHelper.worldTicks(player.field_70170_p)) / 20L) > 0L) {
                        long hour = cd / 3600L;
                        String timeString = "";
                        if (hour > 0L) {
                            cd -= hour * 3600L;
                            timeString = String.format("%02d", hour) + ":";
                        }
                        timeString = timeString + String.format("%02d", cd / 60L) + ":" + String.format("%02d", cd % 60L);
                        list.add(LangKey.MESSAGE_IN_COOLDOWN.getTranslationWithStyle(StyleType.COLOR_OFF, timeString));
                    }
                });
            } else {
                list.add(new TextComponentTranslation("tombstone.item." + this.name + ".use" + (this.func_77636_d(stack) ? 2 : 1), new Object[0]).func_150255_a(StyleType.TOOLTIP_USE.getStyle()));
                list.add(new TextComponentTranslation("tombstone.item." + this.name + ".use3", new Object[0]).func_150255_a(StyleType.TOOLTIP_USE.getStyle()));
            }
        } else {
            list.add(LangKey.TOOLTIP_MORE_INFO.getTranslationWithStyle(StyleType.TOOLTIP_DESC));
        }
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, ItemUseContext context) {
        IBlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        return state.func_177230_c() instanceof BlockDecorativeGrave && (Boolean)state.func_177229_b((IProperty)BlockDecorativeGrave.HAS_SOUL) != false ? EnumActionResult.PASS : EnumActionResult.FAIL;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (EntityHelper.isValidPlayerMP((Entity)player) && hand == EnumHand.MAIN_HAND && player.func_184614_ca().func_77973_b() == this && !EntityHelper.hasCooldown(player, this)) {
            EntityHelper.setCooldown(player, this, 10);
            if (target instanceof EntityZombieVillager) {
                return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
                    if (cap.canPray(player)) {
                        EntityZombieVillager villager = (EntityZombieVillager)target;
                        EntityHelper.addPotion((EntityLivingBase)villager, ModEffects.exorcism, 200, 1, new boolean[0]);
                        villager.field_191992_by = null;
                        villager.field_82234_d = 200;
                        villager.func_184212_Q().func_187227_b(EntityZombieVillager.field_184739_bx, (Object)Boolean.TRUE);
                        villager.func_195063_d(MobEffects.field_76437_t);
                        villager.field_70170_p.func_72960_a((Entity)villager, (byte)16);
                        cap.resetNextPray((EntityPlayerMP)player);
                        PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), (EntityPlayerMP)player);
                        EntityHelper.addKnowledge((EntityPlayerMP)player, 3L);
                        stack.func_77972_a(3, (EntityLivingBase)player);
                        player.func_145747_a(LangKey.MESSAGE_EXORCISM.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
                        Helper.grantAdvancement(player, "adventure/exorcism", new String[0]);
                        return true;
                    }
                    return false;
                }).orElse((Object)false);
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult((EnumActionResult)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
            if (cap.canPray(player)) {
                player.func_184598_c(hand);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }).orElse((Object)EnumActionResult.FAIL), (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, @Nullable World world, EntityLivingBase entity) {
        EntityPlayerMP player;
        if (EntityHelper.isValidPlayerMP((Entity)entity) && !EntityHelper.hasCooldown((EntityPlayer)(player = (EntityPlayerMP)entity), this)) {
            boolean valid = false;
            BlockPos pos = player.func_180425_c();
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        if (!(player.field_70170_p.func_180495_p(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z)).func_177230_c() instanceof BlockDecorativeGrave)) continue;
                        valid = true;
                    }
                }
            }
            if (valid) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    cap.resetNextPray(player);
                    PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), player);
                    EntityHelper.addKnowledge(player, 1L);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    Helper.grantAdvancement((EntityPlayer)player, "adventure/first_pray", new String[0]);
                    if (Helper.isDateAroundHalloween() || Helper.isContributor((EntityPlayer)player) || Helper.getRandom(1, 100) < (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + cap.getTotalPerkPoints()) {
                        Helper.addRandomPotion((EntityPlayer)player, 36000, true);
                    }
                });
            } else {
                player.func_145747_a(LangKey.MESSAGE_CANT_PRAY.getTranslationWithStyle(StyleType.COLOR_OFF));
            }
            EntityHelper.setCooldown((EntityPlayer)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        if (entity != null && entity.field_70170_p.field_72995_K && timeLeft == this.func_77626_a(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityHelper.hasCooldown((EntityPlayer)player, stack)) {
            return false;
        }
        return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
            if (!cap.canPray((EntityPlayer)player)) {
                EntityHelper.setCooldown((EntityPlayer)player, stack, (int)(cap.getNextPray() - TimeHelper.worldTicks(player.field_70170_p)));
                return false;
            }
            return true;
        }).orElse((Object)false);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
            if (cap.getUsedPerkPoints(player) > 1) {
                cap.setPerks(new HashMap<Perk, Integer>());
                EntityHelper.syncTBCapability((EntityPlayerMP)player);
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    @Override
    public String getEnchantSuccessMessage() {
        return LangKey.MESSAGE_PERK_RESET_SUCCESS.getKey();
    }

    @Override
    public String getEnchantFailedMessage() {
        return LangKey.MESSAGE_PERK_RESET_FAILED.getKey();
    }

    @Override
    public int getKnowledge() {
        return 0;
    }
}

