/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModEffects;

public class ItemDustOfVanishing
extends ItemGeneric {
    public ItemDustOfVanishing() {
        super("dust_of_vanishing", ItemDustOfVanishing.getBuilder(true));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(stack)) {
            list.add(new TextComponentTranslation("tombstone.item." + this.name + ".desc", new Object[0]).func_150255_a(StyleType.TOOLTIP_DESC.getStyle()));
            list.add(new TextComponentTranslation("tombstone.item." + this.name + ".use", new Object[0]).func_150255_a(StyleType.TOOLTIP_USE.getStyle()));
        } else {
            list.add(LangKey.TOOLTIP_MORE_INFO.getTranslationWithStyle(StyleType.TOOLTIP_DESC));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == this && !EntityHelper.hasCooldown(player, this)) {
            Vec3d pVec = player.func_174791_d();
            if (!world.field_72995_K) {
                world.func_184148_a(null, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.5f);
                Location spawnPos = this.findBackwardLocation((WorldServer)world, player, 8.0);
                if (!spawnPos.isOrigin()) {
                    Helper.teleportEntity(player, spawnPos);
                } else {
                    spawnPos = this.findBackwardLocation((WorldServer)world, player, 3.0);
                    if (!spawnPos.isOrigin()) {
                        Helper.teleportEntity(player, spawnPos);
                    }
                }
                player.field_70143_R = 0.0f;
                stack.func_190918_g(1);
                EntityHelper.addPotion((EntityLivingBase)player, ModEffects.diversion, 100);
                EntityHelper.setCooldown(player, this, 200);
            }
            ModTombstone.PROXY.produceSmokeColumn(world, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return true;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return EnumActionResult.FAIL;
    }

    private Location findBackwardLocation(WorldServer world, EntityPlayer player, double range) {
        return new SpawnHelper(world, new BlockPos(player.func_174791_d().func_178786_a(player.func_70040_Z().field_72450_a * range, 0.0, player.func_70040_Z().field_72449_c * range)), false).findSafePlace(2, true, true);
    }

    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }
}

