/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ISoulConsumer;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemFishingRodOfMisadventure
extends ItemFishingRod
implements ISoulConsumer {
    private final String name = "fishing_rod_of_misadventure";

    public ItemFishingRodOfMisadventure() {
        super(new Item.Properties().func_200916_a(ModTabs.mainTab).func_200917_a(1).func_200915_b(32));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getTranslation(name) : name).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle());
    }

    public String getSimpleName() {
        return this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(stack)) {
            int id = this.isEnchanted(stack) ? 2 : 1;
            list.add(new TextComponentTranslation("tombstone.item.fishing_rod_of_misadventure.desc" + id, new Object[0]).func_150255_a(StyleType.TOOLTIP_DESC.getStyle()));
            list.add(new TextComponentTranslation("tombstone.item.fishing_rod_of_misadventure.use" + id, new Object[0]).func_150255_a(StyleType.TOOLTIP_USE.getStyle()));
        } else {
            list.add(LangKey.TOOLTIP_MORE_INFO.getTranslationWithStyle(StyleType.TOOLTIP_DESC));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        int malus;
        ItemStack stack = player.func_184586_b(hand);
        int n = malus = this.isEnchanted(stack) ? -50 : -10;
        if (player.field_71104_cf != null) {
            int damage = player.field_71104_cf.func_146034_e(stack);
            if (!this.isEnchanted(stack)) {
                stack.func_77972_a(damage, (EntityLivingBase)player);
            }
            player.func_184609_a(hand);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                EntityFishHook entityfishhook = new EntityFishHook(world, player);
                if (this.isEnchanted(stack)) {
                    entityfishhook.func_191516_a(2);
                }
                entityfishhook.func_191517_b(malus);
                world.func_72838_d((Entity)entityfishhook);
            }
            player.func_184609_a(hand);
            player.func_71029_a(StatList.field_75929_E.func_199076_b((Object)this));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isEnchanted(stack) && super.showDurabilityBar(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (!this.isEnchanted(stack)) {
            super.setDamage(stack, damage);
        }
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return false;
        }
        stack.func_196085_b(0);
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    public String getEnchantSuccessMessage() {
        return LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getKey();
    }

    public String func_77658_a() {
        return "tombstone.item.fishing_rod_of_misadventure";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }
}

