/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemGeneric
extends Item {
    protected final String name;
    private boolean hasEffect = false;
    private boolean isCraftingIngredient = false;

    public ItemGeneric(String name) {
        this(name, ItemGeneric.getBuilder(true));
    }

    public ItemGeneric(String name, boolean hasTab) {
        this(name, ItemGeneric.getBuilder(hasTab));
    }

    public ItemGeneric(String name, Item.Properties builder) {
        super(builder);
        this.name = name;
    }

    public String getSimpleName() {
        return this.name;
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    public ItemGeneric withCraftingInfo() {
        this.isCraftingIngredient = true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasEffect || NBTStackHelper.getBoolean(stack, "enchant");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String lang_key;
        String desc;
        if (this.isCraftingIngredient) {
            list.add(LangKey.MESSAGE_CRAFTING_INGREDIENT.getTranslationWithStyle(StyleType.TOOLTIP_DESC));
        }
        if (!(desc = I18n.func_135052_a((String)(lang_key = "item." + this.name + ".desc"), (Object[])new Object[0])).equals(lang_key)) {
            list.add((ITextComponent)new TextComponentTranslation(LangKey.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, desc, new Object[0]), new Object[0]));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "tombstone.item." + this.name;
    }

    public void addItemDesc(List<ITextComponent> list) {
        this.addItemDesc(list, "", new Object[0]);
    }

    public void addItemDesc(List<ITextComponent> list, String id, Object ... format) {
        list.add(new TextComponentTranslation("tombstone.item." + this.name + ".desc" + id, format).func_150255_a(StyleType.TOOLTIP_DESC.getStyle()));
    }

    public void addItemUse(List<ITextComponent> list) {
        this.addItemUse(list, "", new Object[0]);
    }

    public void addItemUse(List<ITextComponent> list, String id, Object ... format) {
        list.add(new TextComponentTranslation("tombstone.item." + this.name + ".use" + id, format).func_150255_a(StyleType.TOOLTIP_USE.getStyle()));
    }

    public void addInfo(List<ITextComponent> list, LangKey langKey, Object ... format) {
        list.add(langKey.getTranslationWithStyle(StyleType.TOOLTIP_DESC, format));
    }

    public void addItemPosition(List<ITextComponent> list, Location location) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.func_180425_c();
            list.add(LangKey.MESSAGE_DISTANCE.getTranslation((int)location.getPos().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), location.x, location.y, location.z, location.dim));
        }
    }

    static Item.Properties getBuilder(boolean hasTab) {
        return new Item.Properties().func_200916_a((ItemGroup)(hasTab ? ModTabs.mainTab : null)).func_200917_a(64);
    }
}

