/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ISoulConsumer;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTabs;

public abstract class ItemGraveMagic
extends ItemGeneric
implements ISoulConsumer {
    public ItemGraveMagic(String name) {
        super(name, ItemGraveMagic.getBuilder());
    }

    public ItemGraveMagic(String name, Item.Properties builder) {
        super(name, builder);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getTranslation(name) : name).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle());
    }

    protected abstract boolean doEffects(World var1, EntityPlayerMP var2, ItemStack var3);

    protected ItemStack onConsumeItem(EntityPlayer player, ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (!Helper.canShowTooltip(stack)) {
            list.add(LangKey.TOOLTIP_MORE_INFO.getTranslationWithStyle(StyleType.TOOLTIP_DESC));
        }
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                list.add(LangKey.MESSAGE_USE_LEFT.getTranslationWithStyle(StyleType.MESSAGE_NORMAL, uses));
            }
            if ((cd = this.getCooldown(world, stack)) > 10) {
                int min;
                int hour = cd / 72000;
                String timeString = "";
                if (hour > 0) {
                    cd -= hour * 72000;
                    timeString = String.format("%02d", hour) + ":";
                }
                if ((min = cd / 1200) > 0) {
                    cd -= min * 1200;
                    timeString = timeString + String.format("%02d", min) + ":";
                }
                timeString = timeString + String.format("%02d", cd / 20);
                list.add(LangKey.MESSAGE_IN_COOLDOWN.getTranslationWithStyle(StyleType.COLOR_OFF, timeString));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isEnchanted(stack) && !this.isCooldown(world, stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        if (entity.field_70170_p.field_72995_K && timeLeft == this.func_77626_a(stack) && this.isEnchanted(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (EntityHelper.isValidPlayerMP((Entity)entity)) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (this.isEnchanted(stack)) {
                int useCount = this.getUseCount(stack);
                if (useCount < 0) {
                    return ItemStack.field_190927_a;
                }
                if (this.doEffects(world, player, stack)) {
                    ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, world, player.func_180425_c(), 0.5f, 0.5f);
                    if (!this.canConsumeOnUse() || --useCount > 0) {
                        this.setCooldown(world, stack, this.getCastingCooldown());
                        this.setUseCount(stack, useCount);
                        return stack;
                    }
                    return this.onConsumeItem((EntityPlayer)player, stack);
                }
                EntityHelper.setCooldown((EntityPlayer)player, this, 10);
                return stack;
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public abstract int getCastingCooldown();

    public boolean isCooldown(World world, ItemStack stack) {
        return this.getCooldown(world, stack) > 0;
    }

    public int getCooldown(@Nullable World world, ItemStack stack) {
        if (world != null && stack.func_77973_b() == this) {
            return (int)Math.max(0L, NBTStackHelper.getLong(stack, "cooldown_time") - TimeHelper.worldTicks(world));
        }
        return 0;
    }

    public void setCooldown(@Nullable World world, ItemStack stack, int time) {
        if (world != null && stack.func_77973_b() == this) {
            NBTStackHelper.setLong(stack, "cooldown_time", TimeHelper.worldTicks(world) + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.max(0, NBTStackHelper.getInteger(stack, "useCount"));
    }

    protected void setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, "useCount", useCount);
        }
    }

    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    protected static Item.Properties getBuilder() {
        return new Item.Properties().func_200916_a(ModTabs.mainTab).func_200917_a(1).func_200915_b(0);
    }
}

