/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

public class ItemScrollBuff
extends ItemScroll {
    private final SpellBuff spellBuff;

    public ItemScrollBuff(SpellBuff spellBuff) {
        super("scroll_of_" + spellBuff.toString().toLowerCase());
        this.spellBuff = spellBuff;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(stack)) {
            this.addItemDesc(list);
            this.addItemUse(list, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        switch (this.spellBuff.ordinal()) {
            case 0: {
                return (Boolean)ConfigTombstone.allowed_magic_items.allowScrollOfPreservation.get();
            }
            case 1: {
                return (Boolean)ConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibleness.get();
            }
            case 2: {
                return (Boolean)ConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall.get();
            }
            case 3: {
                return (Boolean)ConfigTombstone.allowed_magic_items.allowScrollOfPurification.get();
            }
            case 4: {
                return (Boolean)ConfigTombstone.allowed_magic_items.allowScrollOfTrueSight.get();
            }
        }
        return false;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        EntityHelper.addPotion((EntityLivingBase)player, this.spellBuff.potion, (int)((double)this.spellBuff.duration * (1.0 + (double)EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.mastery_of_scrolls) / 10.0)), this.spellBuff.amplifier, new boolean[0]);
        player.func_145747_a(LangKey.MESSAGE_SPELL_CAST_ON_YOU.getTranslation(new TextComponentString(this.spellBuff.potion.func_76393_a()).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle())).func_150255_a(StyleType.MESSAGE_SPELL.getStyle()));
        Helper.grantAdvancement((EntityPlayer)player, "adventure/use_" + this.spellBuff.getName(), new String[0]);
        return true;
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "tombstone.item." + SpellBuff.values()[this.spellBuff.ordinal()].getScrollName();
    }

    public static enum SpellBuff {
        PRESERVATION(ModEffects.preservation, 12000, 0),
        UNSTABLE_INTANGIBLENESS(ModEffects.unstable_intangibleness, 12000, 0),
        FEATHER_FALL(ModEffects.feather_fall, 12000, 3),
        PURIFICATION(ModEffects.purification, 12000, 1),
        TRUE_SIGHT(ModEffects.true_sight, 12000, 0);

        private final Potion potion;
        private final int duration;
        private final int amplifier;

        private SpellBuff(Potion potion, int duration, int amplifier) {
            this.potion = potion;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        private String getName() {
            return this.name().toLowerCase();
        }

        private String getScrollName() {
            return "scroll_of_" + this.getName();
        }

        public static SpellBuff getRandomBuff() {
            return SpellBuff.values()[Helper.getRandom(0, SpellBuff.values().length - 1)];
        }
    }
}

