/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;

public class ItemScrollOfKnowledge
extends ItemScroll {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(stack)) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list, "1", new Object[0]);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                this.addItemDesc(list, "2", new Object[0]);
                this.addInfo(list, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
                this.addItemUse(list, "2", new Object[0]);
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return (Boolean)ConfigTombstone.allowed_magic_items.allowScrollOfKnowledge.get();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public String getEnchantSuccessMessage() {
        return LangKey.MESSAGE_LOSE_EXPERIENCE.getKey();
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        boolean valid = this.setStoredXp(stack, EntityHelper.getPlayerTotalXp(player));
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
        }
        return valid;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        int i;
        int storedXp = this.getStoredXp(stack);
        if (storedXp > (i = Integer.MAX_VALUE - player.field_71067_cb)) {
            player.func_145747_a(LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.getTranslation());
            return false;
        }
        EntityHelper.setPlayerXp((EntityPlayer)player, EntityHelper.getPlayerTotalXp((EntityPlayer)player) + storedXp);
        player.func_145747_a(LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.getTranslation());
        Helper.grantAdvancement((EntityPlayer)player, "adventure/use_knowledge", new String[0]);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        int storedXp = NBTStackHelper.getInteger(stack, "stored_xp");
        return storedXp > 0 ? storedXp : 0;
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.func_77973_b() != this || xp <= 0) {
            return false;
        }
        NBTStackHelper.setInteger(stack, "stored_xp", xp);
        return true;
    }
}

