/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemTablet;

public class ItemTabletOfRecall
extends ItemTablet {
    public ItemTabletOfRecall() {
        super("tablet_of_recall");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(stack)) {
            this.addItemDesc(list);
            if (!this.isEnchanted(stack)) {
                this.addItemUse(list, "1", new Object[0]);
            } else {
                Location location = this.getTombPos(stack);
                if (!location.isOrigin()) {
                    this.addItemPosition(list, location);
                    this.addItemUse(list, "2", new Object[0]);
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    private boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() != this || location.isOrigin()) {
            return false;
        }
        NBTStackHelper.setLocation(stack, "tombPos", location);
        return true;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return Location.ORIGIN;
        }
        return NBTStackHelper.getLocation(stack, "tombPos");
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return (Boolean)ConfigTombstone.allowed_magic_items.allowTabletOfRecall.get();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return !this.getTombPos(stack).isOrigin();
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        boolean valid = this.setTombPos(stack, new Location(gravePos, (IWorld)world));
        if (valid) {
            this.setUseCount(stack, this.getUseMax());
        }
        return valid;
    }

    @Override
    public String getEnchantSuccessMessage() {
        return LangKey.MESSAGE_BIND_PLACE.getKey();
    }

    @Override
    public void onSneakGrave(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (this.isEnchanted(stack) && !this.isCooldown(world, stack)) {
            this.setTombPos(stack, new Location(gravePos, (IWorld)world));
            this.setCooldown(world, stack, this.getCastingCooldown());
            player.func_145747_a(new TextComponentTranslation(this.getEnchantSuccessMessage(), new Object[0]).func_150255_a(StyleType.MESSAGE_NORMAL.getStyle()));
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        boolean isSameDim = location.isSameDimension(world);
        if (isSameDim && location.isInRange(player.func_180425_c(), 10)) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_TOO_CLOSE_FROM_GRAVE.getTranslation());
            return false;
        }
        if (!isSameDim && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.getTranslation());
            return false;
        }
        CallbackHandler.addCallback(1, () -> {
            EntityPlayerMP newPlayer = Helper.teleportEntity(player, location);
            newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation());
            Helper.grantAdvancement((EntityPlayer)newPlayer, "adventure/use_recall", new String[0]);
        });
        return true;
    }
}

