/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.PerkRegistry;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;

public class SyncCapClientMessage {
    private SyncType syncType;
    private long knowledge;
    private HashMap<Perk, Integer> perks;
    private List<Perk> disabledPerks;
    private Perk perk;
    private int level;
    private long nextPray;

    public SyncCapClientMessage(SyncType syncType, Object ... params) {
        this.syncType = syncType;
        if (syncType == SyncType.ALL) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
            this.nextPray = params.length > 1 ? (Long)params[1] : -1L;
            this.perks = params.length > 2 ? (HashMap)params[2] : new HashMap();
            this.disabledPerks = params.length > 3 ? (List)params[3] : new ArrayList();
        } else if (syncType == SyncType.KNOWLEDGE) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
        } else if (syncType == SyncType.NEXT_PRAY) {
            this.nextPray = params.length > 0 ? (Long)params[0] : -1L;
        } else if (syncType == SyncType.PERKS) {
            this.perks = params.length > 0 ? (HashMap)params[0] : new HashMap();
        } else if (syncType == SyncType.SET_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
            this.level = params.length > 1 ? (Integer)params[1] : 1;
        } else if (syncType == SyncType.REMOVE_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
        }
    }

    static SyncCapClientMessage fromBytes(PacketBuffer buf) {
        SyncType syncType = SyncType.values()[buf.readShort()];
        switch (syncType) {
            case KNOWLEDGE: 
            case NEXT_PRAY: {
                return new SyncCapClientMessage(syncType, buf.readLong());
            }
            case ALL: {
                NBTTagCompound tag;
                long knowledge = buf.readLong();
                long nextPray = buf.readLong();
                try {
                    tag = buf.func_150793_b();
                }
                catch (Exception e) {
                    tag = null;
                }
                return new SyncCapClientMessage(syncType, knowledge, nextPray, SyncCapClientMessage.readPerks(tag), SyncCapClientMessage.readDisabledPerks(tag));
            }
            case PERKS: {
                NBTTagCompound tag;
                try {
                    tag = buf.func_150793_b();
                }
                catch (Exception e) {
                    tag = null;
                }
                return new SyncCapClientMessage(syncType, SyncCapClientMessage.readPerks(tag));
            }
            case SET_PERK: {
                return new SyncCapClientMessage(syncType, PerkRegistry.perkRegistry.getValue(buf.readInt()), buf.readInt());
            }
            case REMOVE_PERK: {
                return new SyncCapClientMessage(syncType, PerkRegistry.perkRegistry.getValue(buf.readInt()));
            }
        }
        return new SyncCapClientMessage(syncType, buf.readLong(), buf.readLong());
    }

    private static List<Perk> readDisabledPerks(NBTTagCompound tag) {
        ArrayList<Perk> disabledPerks = new ArrayList<Perk>();
        if (tag != null && tag.func_150297_b("disabledPerks", 9)) {
            NBTTagList tagDisabledPerks = tag.func_150295_c("disabledPerks", 10);
            for (int i = 0; i < tagDisabledPerks.size(); ++i) {
                Perk perk;
                NBTTagCompound tagPerk = tagDisabledPerks.func_150305_b(i);
                if (!tagPerk.func_150297_b("id", 3) || (perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"))) == null) continue;
                disabledPerks.add(perk);
            }
        }
        return disabledPerks;
    }

    private static HashMap<Perk, Integer> readPerks(NBTTagCompound tag) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        if (tag != null && tag.func_150297_b("perks", 9)) {
            NBTTagList tagPerks = tag.func_150295_c("perks", 10);
            for (int i = 0; i < tagPerks.size(); ++i) {
                Perk perk;
                NBTTagCompound tagPerk = tagPerks.func_150305_b(i);
                if (!tagPerk.func_150297_b("id", 3) || !tagPerk.func_150297_b("level", 3) || (perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"))) == null) continue;
                perks.put(perk, tagPerk.func_74762_e("level"));
            }
        }
        return perks;
    }

    static void toBytes(SyncCapClientMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.syncType.ordinal());
        if (msg.syncType == SyncType.KNOWLEDGE || msg.syncType == SyncType.ALL) {
            buf.writeLong(msg.knowledge);
        }
        if (msg.syncType == SyncType.NEXT_PRAY || msg.syncType == SyncType.ALL) {
            buf.writeLong(msg.nextPray);
        }
        if (msg.syncType == SyncType.PERKS || msg.syncType == SyncType.ALL) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList tagPerks = new NBTTagList();
            for (Map.Entry<Perk, Integer> entry : msg.perks.entrySet()) {
                NBTTagCompound tagPerk = new NBTTagCompound();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)entry.getKey()));
                tagPerk.func_74768_a("level", entry.getValue().intValue());
                tagPerks.add((INBTBase)tagPerk);
            }
            tag.func_74782_a("perks", (INBTBase)tagPerks);
            if (msg.syncType == SyncType.ALL) {
                NBTTagList tagDisabledPerks = new NBTTagList();
                for (Perk perk : PerkRegistry.perkRegistry.getValues()) {
                    if (!perk.isDisabled()) continue;
                    NBTTagCompound tagDisabledPerk = new NBTTagCompound();
                    tagDisabledPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)perk));
                    tagDisabledPerks.add((INBTBase)tagDisabledPerk);
                }
                tag.func_74782_a("disabledPerks", (INBTBase)tagDisabledPerks);
            }
            buf.func_150786_a(tag);
        }
        if (msg.syncType == SyncType.SET_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
            buf.writeInt(msg.level);
        }
        if (msg.syncType == SyncType.REMOVE_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
        }
    }

    public static class Handler {
        static void handle(SyncCapClientMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                        switch (message.syncType) {
                            case ALL: {
                                cap.setKnowledge(message.knowledge);
                                cap.setNextPray(message.nextPray);
                                cap.setPerks(message.perks);
                                Helper.DISABLED_PERKS = message.disabledPerks;
                                break;
                            }
                            case KNOWLEDGE: {
                                cap.setKnowledge(message.knowledge);
                                break;
                            }
                            case PERKS: {
                                cap.setPerks(message.perks);
                                break;
                            }
                            case SET_PERK: {
                                cap.setPerk(message.perk, message.level);
                                break;
                            }
                            case REMOVE_PERK: {
                                cap.removePerk(message.perk);
                                break;
                            }
                            case NEXT_PRAY: {
                                cap.setNextPray(message.nextPray);
                                break;
                            }
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum SyncType {
        ALL,
        KNOWLEDGE,
        PERKS,
        SET_PERK,
        REMOVE_PERK,
        NEXT_PRAY;

    }
}

