/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;

public class UpdateClientMessage {
    private BlockPos spawnPos;
    private int range;
    private int tabletMaxUse;
    private boolean unbreakableDecorativeGrave;
    private boolean nerfShadowStep;
    private boolean enableEnchantmentShadowStep;
    private boolean enableEnchantmentSoulbound;
    private boolean dateAroundHalloween;
    private boolean isContributor;

    public UpdateClientMessage(BlockPos spawnPos, int range, int tabletMaxUse, boolean unbreakableDecorativeGrave, boolean nerfShadowStep, boolean enableEnchantmentShadowStep, boolean enableEnchantmentSoulbound, boolean dateAroundHalloween, boolean isContributor) {
        this.spawnPos = spawnPos;
        this.range = range;
        this.tabletMaxUse = tabletMaxUse;
        this.unbreakableDecorativeGrave = unbreakableDecorativeGrave;
        this.nerfShadowStep = nerfShadowStep;
        this.enableEnchantmentShadowStep = enableEnchantmentShadowStep;
        this.enableEnchantmentSoulbound = enableEnchantmentSoulbound;
        this.dateAroundHalloween = dateAroundHalloween;
        this.isContributor = isContributor;
    }

    static UpdateClientMessage fromBytes(PacketBuffer buf) {
        return new UpdateClientMessage(BlockPos.func_177969_a((long)buf.readLong()), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateClientMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.spawnPos.func_177986_g());
        buf.writeInt(msg.range);
        buf.writeInt(msg.tabletMaxUse);
        buf.writeBoolean(msg.unbreakableDecorativeGrave);
        buf.writeBoolean(msg.nerfShadowStep);
        buf.writeBoolean(msg.enableEnchantmentShadowStep);
        buf.writeBoolean(msg.enableEnchantmentSoulbound);
        buf.writeBoolean(msg.dateAroundHalloween);
        buf.writeBoolean(msg.isContributor);
    }

    public static class Handler {
        static void handle(UpdateClientMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ConfigTombstone.decorative_grave.serverTabletMaxUse = message.tabletMaxUse;
                ConfigTombstone.decorative_grave.serverUnbreakableDecorativeGrave = message.unbreakableDecorativeGrave;
                ConfigTombstone.enchantments.serverNerfShadowStep = message.nerfShadowStep;
                ConfigTombstone.enchantments.serverEnableEnchantmentShadowStep = message.enableEnchantmentShadowStep;
                ConfigTombstone.enchantments.serverEnableEnchantmentSoulbound = message.enableEnchantmentSoulbound;
                SpawnProtectionHandler.getInstance().setSpawnProtection(message.spawnPos, message.range);
                Helper.isHalloween = message.dateAroundHalloween;
                Helper.isContributor = message.isContributor;
                PacketHandler.sendToServer(new UpdateServerMessage((GraveModel)((Object)((Object)ConfigTombstone.client.favoriteGrave.get())), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), true));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

