/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;

public class UpdateServerMessage {
    private GraveModel graveModel;
    private boolean equipElytraInPriority;
    private boolean displayKnowledgeMessage;
    private boolean isLogin;

    public UpdateServerMessage(GraveModel graveModel, boolean equipElytraInPriority, boolean displayKnowledgeMessage, boolean isLogin) {
        this.graveModel = graveModel;
        this.equipElytraInPriority = equipElytraInPriority;
        this.displayKnowledgeMessage = displayKnowledgeMessage;
        this.isLogin = isLogin;
    }

    static UpdateServerMessage fromBytes(PacketBuffer buf) {
        return new UpdateServerMessage(GraveModel.getModel(buf.readInt()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateServerMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.graveModel.ordinal());
        buf.writeBoolean(msg.equipElytraInPriority);
        buf.writeBoolean(msg.displayKnowledgeMessage);
        buf.writeBoolean(msg.isLogin);
    }

    public static class Handler {
        static void handle(UpdateServerMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityPlayerMP player = ((NetworkEvent.Context)ctx.get()).getSender();
                DeathHandler.instance.setOptionFavoriteGrave(player.func_110124_au(), message.graveModel).setOptionEquipElytraInPriority(player.func_110124_au(), message.equipElytraInPriority).setOptionKnowledgeMessage(player.func_110124_au(), message.displayKnowledgeMessage);
                if (!message.isLogin) {
                    Helper.grantAdvancement((EntityPlayer)player, "adventure/choose_grave_type", new String[0]);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

