/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.block.BlockDarkMarble;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.Registrable;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks
extends Registrable {
    public static final EnumMap<GraveModel, Block> graves = new EnumMap(GraveModel.class);
    public static final EnumMap<GraveModel, Block> decorative_graves = new EnumMap(GraveModel.class);
    public static final TileEntityType<TileEntityDecorativeGrave> DECORATIVE_GRAVE = TileEntityType.func_200966_a((String)"tombstone:decorative_grave", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityDecorativeGrave::new));
    public static final TileEntityType<TileEntityGrave> GRAVE = TileEntityType.func_200966_a((String)"tombstone:grave", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityGrave::new));
    public static Block dark_marble = Blocks.field_150350_a;

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        for (GraveModel graveModel : GraveModel.values()) {
            graves.put(graveModel, ModBlocks.registerForgeEntry(event.getRegistry(), new BlockGrave(graveModel), graveModel.func_176610_l()));
            decorative_graves.put(graveModel, ModBlocks.registerForgeEntry(event.getRegistry(), new BlockDecorativeGrave(graveModel), "decorative_" + graveModel.func_176610_l()));
        }
        dark_marble = ModBlocks.registerForgeEntry(event.getRegistry(), new BlockDarkMarble(), "dark_marble");
    }

    @SubscribeEvent
    public static void registerItemBlock(RegistryEvent.Register<Item> event) {
        for (GraveModel graveModel : GraveModel.values()) {
            Block decorativeGrave = decorative_graves.get((Object)graveModel);
            ModBlocks.registerForgeEntry(event.getRegistry(), new ItemBlockGrave(decorativeGrave), decorativeGrave.getRegistryName());
        }
        ModBlocks.registerForgeEntry(event.getRegistry(), new ItemBlock(dark_marble, new Item.Properties().func_200916_a(ModTabs.mainTab)), dark_marble.getRegistryName());
    }
}

