/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.network.UpdateServerMessage;

@Mod.EventBusSubscriber(modid="tombstone")
@Config(modid="tombstone", name="tombstone", category="")
public class ConfigTombstone {
    @Config.Name(value="client")
    @Config.LangKey(value="tombstone.config_cat.client")
    @Config.Comment(value={"Personal Options that can be edited even on server"})
    public static CatClient client = new CatClient();
    @Config.Name(value="compatibilities")
    @Config.LangKey(value="tombstone.config_cat.compatibilities")
    @Config.Comment(value={"Allows to enable some features related to others mods"})
    public static CatCompatibilities compatibilities = new CatCompatibilities();
    @Config.Name(value="village_siege")
    @Config.LangKey(value="tombstone.config_cat.village_siege")
    @Config.Comment(value={"Allows to define the conditions for a village siege to begin"})
    public static CatVillageSiege village_siege = new CatVillageSiege();
    @Config.Name(value="enchantments")
    @Config.LangKey(value="tombstone.config_cat.enchantments")
    @Config.Comment(value={"Allows to customize or disable the enchantments"})
    public static CatEnchantments enchantments = new CatEnchantments();
    @Config.Name(value="decorativeGrave")
    @Config.LangKey(value="tombstone.config_cat.decorative_grave")
    @Config.Comment(value={"For settings related to decorative tombs and magic items"})
    public static CatDecorativeGrave decorativeGrave = new CatDecorativeGrave();
    @Config.Name(value="loot")
    @Config.LangKey(value="tombstone.config_cat.loot")
    @Config.Comment(value={"Allows to change the chance to drop some items"})
    public static CatLoot loot = new CatLoot();
    @Config.Name(value="allowedMagicItems")
    @Config.LangKey(value="tombstone.config_cat.allowed_magic_items")
    @Config.Comment(value={"Allows to disable some magic items"})
    public static CatAllowedMagicItems allowedMagicItems = new CatAllowedMagicItems();
    @Config.Name(value="general")
    @Config.LangKey(value="tombstone.config_cat.general")
    @Config.Comment(value={"Miscellaneous options"})
    public static CatGeneral general = new CatGeneral();
    @Config.Name(value="recovery")
    @Config.LangKey(value="tombstone.config_cat.recovery")
    @Config.Comment(value={"Options related to the command recovery and auto-save of players"})
    public static CatRecovery recovery = new CatRecovery();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tombstone")) {
            ConfigManager.sync((String)"tombstone", (Config.Type)Config.Type.INSTANCE);
            if (ConfigTombstone.client.favoriteGrave == null) {
                ConfigTombstone.client.favoriteGrave = GraveModel.getDefaultGrave();
            }
            if (!ConfigTombstone.client.favoriteGrave.equals((Object)CatClient.lastFavoriteGrave) || CatClient.lastEquipElytraInPriority != ConfigTombstone.client.equipElytraInPriority || CatClient.lastDisplayKnowledgeMessage != ConfigTombstone.client.displayKnowledgeMessage) {
                CatClient.lastFavoriteGrave = ConfigTombstone.client.favoriteGrave;
                CatClient.lastEquipElytraInPriority = ConfigTombstone.client.equipElytraInPriority;
                CatClient.lastDisplayKnowledgeMessage = ConfigTombstone.client.displayKnowledgeMessage;
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerMessage(ConfigTombstone.client.favoriteGrave, ConfigTombstone.client.equipElytraInPriority, ConfigTombstone.client.displayKnowledgeMessage, false));
            }
            if (Minecraft.func_71410_x().func_71356_B()) {
                ConfigTombstone.updateServerDatas();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.player)) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            assert (player.func_184102_h() != null);
            BlockPos spawnPos = player.func_184102_h().func_71218_a(0).func_175694_M();
            int range = player.func_184102_h().func_71262_S() ? player.func_184102_h().func_82357_ak() : 0;
            PacketHandler.INSTANCE.sendTo((IMessage)new UpdateClientMessage(spawnPos, range, ConfigTombstone.general.handlePlayerXp, ConfigTombstone.general.ghostlyShapeDuration, ConfigTombstone.decorativeGrave.tabletMaxUse, ConfigTombstone.decorativeGrave.unbreakableDecorativeGrave, ConfigTombstone.decorativeGrave.cooldownToPray, ConfigTombstone.enchantments.nerfShadowStep, ConfigTombstone.enchantments.enableEnchantmentShadowStep, ConfigTombstone.enchantments.enableEnchantmentSoulbound, ConfigTombstone.enchantments.enableEnchantmentMagicSiphon, ConfigTombstone.enchantments.enableEnchantmentPlagueBringer, ConfigTombstone.allowedMagicItems.allowBookOfDisenchantment, ConfigTombstone.allowedMagicItems.allowVoodooPoppet, ConfigTombstone.loot.chanceLootLostTablet, Helper.isDateAroundHalloween(player.field_70170_p), Helper.isContributor((EntityPlayer)player), ConfigTombstone.general.xpLoss, ConfigTombstone.general.chanceEnchantedGraveKey), player);
            EntityHelper.syncTBCapability(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            ConfigTombstone.updateServerDatas();
        } else {
            ConfigTombstone.updateClientDatas();
        }
    }

    private static void updateServerDatas() {
        CatGeneral.serverHandlePlayerXp = ConfigTombstone.general.handlePlayerXp;
        CatGeneral.serverGhostlyShapeDuration = ConfigTombstone.general.ghostlyShapeDuration;
        CatDecorativeGrave.serverTabletMaxUse = ConfigTombstone.decorativeGrave.tabletMaxUse;
        CatDecorativeGrave.serverUnbreakableDecorativeGrave = ConfigTombstone.decorativeGrave.unbreakableDecorativeGrave;
        CatDecorativeGrave.serverCooldownToPray = ConfigTombstone.decorativeGrave.cooldownToPray;
        CatEnchantments.serverNerfShadowStep = ConfigTombstone.enchantments.nerfShadowStep;
        CatEnchantments.serverEnableEnchantmentShadowStep = ConfigTombstone.enchantments.enableEnchantmentShadowStep;
        CatEnchantments.serverEnableEnchantmentSoulbound = ConfigTombstone.enchantments.enableEnchantmentSoulbound;
        CatEnchantments.serverEnableEnchantmentMagicSiphon = ConfigTombstone.enchantments.enableEnchantmentMagicSiphon;
        CatEnchantments.serverEnableEnchantmentPlagueBringer = ConfigTombstone.enchantments.enableEnchantmentPlagueBringer;
        CatAllowedMagicItems.serverAllowBookOfDisenchantment = ConfigTombstone.allowedMagicItems.allowBookOfDisenchantment;
        CatAllowedMagicItems.serverAllowVoodooPoppet = ConfigTombstone.allowedMagicItems.allowVoodooPoppet;
        CatLoot.serverChanceLootLostTablet = ConfigTombstone.loot.chanceLootLostTablet;
        CatGeneral.serverXpLoss = ConfigTombstone.general.xpLoss;
        CatGeneral.serverChanceEnchantedGraveKey = ConfigTombstone.general.chanceEnchantedGraveKey;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleClientPacket(UpdateClientMessage message) {
        CatGeneral.serverHandlePlayerXp = message.handlePlayerXp;
        CatGeneral.serverGhostlyShapeDuration = message.ghostlyShapeDuration;
        CatDecorativeGrave.serverTabletMaxUse = message.tabletMaxUse;
        CatDecorativeGrave.serverUnbreakableDecorativeGrave = message.unbreakableDecorativeGrave;
        CatDecorativeGrave.serverCooldownToPray = message.cooldownToPray;
        CatEnchantments.serverNerfShadowStep = message.nerfShadowStep;
        CatEnchantments.serverEnableEnchantmentShadowStep = message.enableEnchantmentShadowStep;
        CatEnchantments.serverEnableEnchantmentSoulbound = message.enableEnchantmentSoulbound;
        CatEnchantments.serverEnableEnchantmentMagicSiphon = message.enableEnchantmentMagicSiphon;
        CatEnchantments.serverEnableEnchantmentPlagueBringer = message.enableEnchantmentPlagueBringer;
        CatAllowedMagicItems.serverAllowBookOfDisenchantment = message.allowBookOfDisenchantment;
        CatAllowedMagicItems.serverAllowVoodooPoppet = message.allowVoodooPoppet;
        CatLoot.serverChanceLootLostTablet = message.chanceLootLostTablet;
        CatGeneral.serverXpLoss = message.xpLoss;
        CatGeneral.serverChanceEnchantedGraveKey = message.chanceEnchantedGraveKey;
    }

    private static void updateClientDatas() {
        CatClient.lastFavoriteGrave = ConfigTombstone.client.favoriteGrave;
        CatClient.lastEquipElytraInPriority = ConfigTombstone.client.equipElytraInPriority;
        CatClient.lastDisplayKnowledgeMessage = ConfigTombstone.client.displayKnowledgeMessage;
    }

    public static class CatRecovery {
        @Config.Name(value="recoveryPlayerEnable")
        @Config.LangKey(value="tombstone.config.recovery_player_enable")
        @Config.Comment(value={"Enables to backup automatically players"})
        public boolean recoveryPlayerEnable = true;
        @Config.Name(value="recoveryPlayerTimer")
        @Config.LangKey(value="tombstone.config.recovery_player_timer")
        @Config.Comment(value={"Time in minutes between players' backups"})
        @Config.RangeInt(min=10, max=1000)
        public int recoveryPlayerTimer = 40;
        @Config.Name(value="recoveryPlayerMaxSaves")
        @Config.LangKey(value="tombstone.config.recovery_player_max_saves")
        @Config.Comment(value={"Maximum number of backups per player"})
        @Config.RangeInt(min=5, max=100)
        public int recoveryPlayerMaxSaves = 15;
        @Config.Name(value="recoveryFamiliarEnable")
        @Config.LangKey(value="tombstone.config.recovery_familiar_enable")
        @Config.Comment(value={"Enables to backup automatically dead familiars"})
        public boolean recoveryFamiliarEnable = true;
    }

    public static class CatGeneral {
        @Config.Name(value="handlePlayerDeath")
        @Config.LangKey(value="tombstone.config.handle_player_death")
        @Config.Comment(value={"Whether to handle player death"})
        public boolean handlePlayerDeath = true;
        @Config.Name(value="handlePlayerXp")
        @Config.LangKey(value="tombstone.config.handle_player_xp")
        @Config.Comment(value={"Whether to handle player experience"})
        public boolean handlePlayerXp = true;
        static boolean serverHandlePlayerXp = true;
        @Config.Name(value="restoreEffectsOnDeath")
        @Config.LangKey(value="tombstone.config.restore_effects_on_death")
        @Config.Comment(value={"Whether to restore beneficial effects after a player dies"})
        public boolean restoreEffectsOnDeath = false;
        @Config.Name(value="logPlayerGrave")
        @Config.LangKey(value="tombstone.config.log_player_grave")
        @Config.Comment(value={"Whether to log the positions of players' graves"})
        public boolean logPlayerGrave = true;
        @Config.Name(value="playerGraveAccess")
        @Config.LangKey(value="tombstone.config.player_grave_access")
        @Config.Comment(value={"Whether to require a Grave's Key to access graves"})
        public boolean playerGraveAccess = true;
        @Config.Name(value="graveKeyOnDeath")
        @Config.LangKey(value="tombstone.config.grave_key_on_death")
        @Config.Comment(value={"Whether to always give players a Grave's Key on death"})
        public boolean graveKeyOnDeath = true;
        @Config.Name(value="chanceEnchantedGraveKey")
        @Config.LangKey(value="tombstone.config.chance_enchanted_grave_key")
        @Config.Comment(value={"The chance that a player receives an already enchanted Grave's Key on death"})
        @Config.RangeInt(min=-1, max=100)
        public int chanceEnchantedGraveKey = 0;
        static int serverChanceEnchantedGraveKey = 0;
        @Config.Name(value="xpLoss")
        @Config.LangKey(value="tombstone.config.xp_loss")
        @Config.Comment(value={"Experience loss on death (%%)"})
        @Config.RangeInt(min=0, max=100)
        public int xpLoss = 0;
        static int serverXpLoss = 0;
        @Config.Name(value="decayTime")
        @Config.LangKey(value="tombstone.config.decay_time")
        @Config.Comment(value={"The time in minutes before a Grave's Key isn't required to open a grave (-1 = disabled)"})
        @Config.RangeInt(min=-1)
        public int decayTime = -1;
        @Config.Name(value="teleportDim")
        @Config.LangKey(value="tombstone.config.teleport_dim")
        @Config.Comment(value={"Allows teleportation to other dimensions"})
        public boolean teleportDim = true;
        @Config.Name(value="pvpMode")
        @Config.LangKey(value="tombstone.config.pvp_mode")
        @Config.Comment(value={"Enables PvP mode, which allows players to open graves of players they kill"})
        public boolean pvpMode = true;
        @Config.Name(value="snifferRange")
        @Config.LangKey(value="tombstone.config.sniffer_range")
        @Config.Comment(value={"The radius in which items should be collected when a grave is spawned"})
        @Config.RangeInt(min=1, max=10)
        public int snifferRange = 5;
        @Config.Name(value="knowledgeLoss")
        @Config.LangKey(value="tombstone.config.knowledge_loss")
        @Config.Comment(value={"Knowledge of Death loss why dying"})
        @Config.RangeInt(min=0, max=500)
        public int knowledgeLoss = 0;
        @Config.Name(value="ghostlyShapeDuration")
        @Config.LangKey(value="tombstone.config.ghostly_shape_duration")
        @Config.Comment(value={"The duration of the Ghostly Shape effect in seconds"})
        @Config.RangeInt(min=0)
        public int ghostlyShapeDuration = 120;
        static int serverGhostlyShapeDuration = 120;
        @Config.Name(value="nerfGhostlyShape")
        @Config.LangKey(value="tombstone.config.nerf_ghostly_shape")
        @Config.Comment(value={"Whether to cancel the Ghostly Shape effect on breaking a block or opening a chest"})
        public boolean nerfGhostlyShape = false;
        @Config.Name(value="chanceLossOnDeath")
        @Config.LangKey(value="tombstone.config.chance_loss_on_death")
        @Config.Comment(value={"The chance that some items are lost on death"})
        @Config.RangeInt(min=0, max=100)
        public int chanceLossOnDeath = 0;
        @Config.Name(value="percentLossOnDeath")
        @Config.LangKey(value="tombstone.config.percent_loss_on_death")
        @Config.Comment(value={"The percentage of items that are lost on death"})
        @Config.RangeInt(min=0, max=100)
        public int percentLossOnDeath = 0;
        @Config.Name(value="preventDeathOutsideWorld")
        @Config.LangKey(value="tombstone.config.prevent_death_outside_world")
        @Config.Comment(value={"Prevents death outside of world borders"})
        public boolean preventDeathOutsideWorld = false;
        @Config.Name(value="gravesByPassGriefingRules")
        @Config.LangKey(value="tombstone.config.graves_by_pass_griefing_rules")
        @Config.Comment(value={"Whether graves should be allowed to bypass anti-griefing rules"})
        public boolean gravesByPassGriefingRules = true;
        @Config.Name(value="unhandledBeneficialEffects")
        @Config.LangKey(value="tombstone.config.unhandled_beneficial_effects")
        @Config.Comment(value={"Beneficial effects that can't used by certain features such as ankh of pray, lollipop, scroll of preservation, alchemy perk and magic siphon enchantment"})
        public String[] unhandledBeneficialEffects = new String[]{"tombstone:ghostly_shape", "tombstone:preservation", "tombstone:exorcism", "extraalchemy", "astralsorcery:potiontimefreeze", "xreliquary:flight_potion"};
        @Config.Name(value="unhandledHarmfulEffects")
        @Config.LangKey(value="tombstone.config.unhandled_harmful_effects")
        @Config.Comment(value={"Harmful effects that can't used by certain features such as tablet of cupidity and the enchantment plague bringer"})
        public String[] unhandledHarmfulEffects = new String[]{"minecraft:nausea"};
        @Config.Name(value="whiteListBlocks")
        @Config.LangKey(value="tombstone.config.whitelist_blocks")
        @Config.Comment(value={"Blocks that can be replaced by graves"})
        public String[] whiteListBlocks = new String[]{"minecraft:tallgrass:0", "minecraft:tallgrass:1", "minecraft:tallgrass:2", "minecraft:deadbush:0", "minecraft:double_plant:0", "minecraft:double_plant:1", "minecraft:double_plant:2", "minecraft:double_plant:3", "minecraft:double_plant:4", "minecraft:double_plant:5", "minecraft:snow_layer:0"};
        @Config.Name(value="noGraveLocation")
        @Config.LangKey(value="tombstone.config.no_grave_location")
        @Config.Comment(value={"Coordinates where graves shouldn't spawn"})
        public String[] noGraveLocation = new String[]{"0, 0, 0, -10000, 20"};
        @Config.Name(value="chanceMobOnGraveRecovery")
        @Config.LangKey(value="tombstone.config.chance_mob_on_grave_recovery")
        @Config.Comment(value={"The chance that creatures appear after the contents of a grave are retrieved"})
        @Config.RangeInt(min=0, max=100)
        public int chanceMobOnGraveRecovery = 0;
        @Config.Name(value="persistantHalloween")
        @Config.LangKey(value="tombstone.config.persistant_halloween")
        @Config.Comment(value={"The Halloween features also happen outside the dates of the event"})
        @Config.RequiresMcRestart
        public boolean persistantHalloween = false;
        @Config.Name(value="allowBeyondTheGraveDamage")
        @Config.LangKey(value="tombstone.config.allow_beyond_the_grave_damage")
        @Config.Comment(value={"Allows players to be hurt by special damages related to some items"})
        public boolean allowBeyondTheGraveDamage = true;

        public boolean isHandlingPlayerXp() {
            return serverHandlePlayerXp;
        }

        public int getChanceEnchantedGraveKey() {
            return serverChanceEnchantedGraveKey;
        }

        public int getXpLoss() {
            return serverXpLoss;
        }

        public int getGhostlyShapeDuration() {
            return serverGhostlyShapeDuration;
        }
    }

    public static class CatAllowedMagicItems {
        @Config.Name(value="allowBookOfDisenchantment")
        @Config.LangKey(value="tombstone.item.book_of_disenchantment.name")
        @Config.Comment(value={"Book of Disenchantment"})
        public boolean allowBookOfDisenchantment = true;
        static boolean serverAllowBookOfDisenchantment;
        @Config.Name(value="allowGraveKey")
        @Config.LangKey(value="tombstone.item.grave_key.name")
        @Config.Comment(value={"Grave's Key"})
        public boolean allowGraveKey = true;
        @Config.Name(value="allowLostTablet")
        @Config.LangKey(value="tombstone.item.lost_tablet.name")
        @Config.Comment(value={"Lost Tablet"})
        public boolean allowLostTablet = true;
        @Config.Name(value="allowScrollOfKnowledge")
        @Config.LangKey(value="tombstone.item.scroll_of_knowledge.name")
        @Config.Comment(value={"Scroll of Knowledge"})
        public boolean allowScrollOfKnowledge = true;
        @Config.Name(value="allowTabletOfAssistance")
        @Config.LangKey(value="tombstone.item.tablet_of_assistance.name")
        @Config.Comment(value={"Tablet of Assistance"})
        public boolean allowTabletOfAssistance = true;
        @Config.Name(value="allowTabletOfRecall")
        @Config.LangKey(value="tombstone.item.tablet_of_recall.name")
        @Config.Comment(value={"Tablet of Recall"})
        public boolean allowTabletOfRecall = true;
        @Config.Name(value="allowTabletOfHome")
        @Config.LangKey(value="tombstone.item.tablet_of_home.name")
        @Config.Comment(value={"Tablet of Home"})
        public boolean allowTabletOfHome = true;
        @Config.Name(value="allowTabletOfCupidity")
        @Config.LangKey(value="tombstone.item.tablet_of_cupidity.name")
        @Config.Comment(value={"Tablet of Cupidity"})
        public boolean allowTabletOfCupidity = true;
        @Config.Name(value="allowVoodooPoppet")
        @Config.LangKey(value="tombstone.item.voodoo_poppet.name")
        @Config.Comment(value={"Voodoo Poppet"})
        public boolean allowVoodooPoppet = true;
        static boolean serverAllowVoodooPoppet;
        @Config.Name(value="allowScrollOfPreservation")
        @Config.LangKey(value="tombstone.item.scroll_of_preservation.name")
        @Config.Comment(value={"Scroll of Preservation"})
        public boolean allowScrollOfPreservation = true;
        @Config.Name(value="allowScrollOfUnstableIntangibleness")
        @Config.LangKey(value="tombstone.item.scroll_of_unstable_intangibleness.name")
        @Config.Comment(value={"Scroll of Unstable Intangibility"})
        public boolean allowScrollOfUnstableIntangibleness = true;
        @Config.Name(value="allowScrollOfFeatherFall")
        @Config.LangKey(value="tombstone.item.scroll_of_feather_fall.name")
        @Config.Comment(value={"Scroll of Feather Falling"})
        public boolean allowScrollOfFeatherFall = true;
        @Config.Name(value="allowScrollOfPurification")
        @Config.LangKey(value="tombstone.item.scroll_of_purification.name")
        @Config.Comment(value={"Scroll of Purification"})
        public boolean allowScrollOfPurification = true;
        @Config.Name(value="allowScrollOfTrueSight")
        @Config.LangKey(value="tombstone.item.scroll_of_true_sight.name")
        @Config.Comment(value={"Scroll of True Sight"})
        public boolean allowScrollOfTrueSight = true;
        @Config.Name(value="allowScrollOfReach")
        @Config.LangKey(value="tombstone.item.scroll_of_reach.name")
        @Config.Comment(value={"Scroll of Reach"})
        public boolean allowScrollOfReach = true;

        public boolean isAllowedBookOfDisenchantment() {
            return serverAllowBookOfDisenchantment;
        }

        public boolean isAllowedVoodooPoppet() {
            return serverAllowVoodooPoppet;
        }
    }

    public static class CatLoot {
        @Config.Name(value="chanceLootLostTablet")
        @Config.LangKey(value="tombstone.config.chance_loot_lost_tablet")
        @Config.Comment(value={"Chance to loot a Lost Tablet by fishing"})
        @Config.RangeInt(min=0, max=100)
        public int chanceLootLostTablet = 5;
        static int serverChanceLootLostTablet;
        @Config.Name(value="chanceGraveDust")
        @Config.LangKey(value="tombstone.config.chance_grave_dust")
        @Config.Comment(value={"Chance on 1000 for undead mobs to drop Grave's Dust"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceGraveDust = 100;
        @Config.Name(value="undeadCanDropSkull")
        @Config.LangKey(value="tombstone.config.undead_can_drop_skull")
        @Config.Comment(value={"Allows the undeads to have a low chance to drop their skull"})
        public boolean undeadCanDropSkull = true;
        @Config.Name(value="chanceSoulReceptacleOnBoss")
        @Config.LangKey(value="tombstone.config.chance_soul_receptacle_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a Soul Receptacle on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceSoulReceptacleOnBoss = 50;
        @Config.Name(value="chanceRandomScrollOnBoss")
        @Config.LangKey(value="tombstone.config.chance_random_scroll_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a random scroll on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceRandomScrollOnBoss = 100;
        @Config.Name(value="chanceRandomPoppetOnBoss")
        @Config.LangKey(value="tombstone.config.chance_random_poppet_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a random poppet on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceRandomPoppetOnBoss = 100;
        @Config.Name(value="chanceDecorativeGraveOnBoss")
        @Config.LangKey(value="tombstone.config.chance_decorative_grave_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a decorative grave on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceDecorativeGraveOnBoss = 50;
        @Config.Name(value="treasureLootTable")
        @Config.LangKey(value="tombstone.config.treasure_loot_table")
        @Config.Comment(value={"Defines the allowed loottables having a chance to contain a magic item from Tombstone"})
        public String[] treasureLootTable = new String[]{"minecraft:chests/end_city_treasure", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/nether_bridge", "minecraft:chests/stronghold_library", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion"};

        public int getChanceLootLostTablet() {
            return serverChanceLootLostTablet;
        }
    }

    public static class CatDecorativeGrave {
        @Config.Name(value="chanceSoul")
        @Config.LangKey(value="tombstone.config.chance_soul")
        @Config.Comment(value={"Chance on 1000 that a soul appears on a grave"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceSoul = 100;
        @Config.Name(value="timeSoul")
        @Config.LangKey(value="tombstone.config.time_soul")
        @Config.Comment(value={"Time in minutes to check if a soul appears on a grave"})
        @Config.RangeInt(min=10, max=10000)
        public int timeSoul = 30;
        @Config.Name(value="tabletMaxUse")
        @Config.LangKey(value="tombstone.config.tablet_max_use")
        @Config.Comment(value={"Maximum uses of a tablet"})
        @Config.RangeInt(min=1, max=20)
        public int tabletMaxUse = 10;
        static int serverTabletMaxUse = 10;
        @Config.Name(value="unbreakableDecorativeGrave")
        @Config.LangKey(value="tombstone.config.unbreakable_decorative_grave")
        @Config.Comment(value={"Sets the decorative graves unbreakable"})
        public boolean unbreakableDecorativeGrave = false;
        static boolean serverUnbreakableDecorativeGrave = false;
        @Config.Name(value="chancePrayReward")
        @Config.LangKey(value="tombstone.config.chance_pray_reward")
        @Config.Comment(value={"Chance to receive a random beneficial spell effect when praying near a grave"})
        @Config.RangeInt(min=0, max=100)
        public int chancePrayReward = 40;
        @Config.Name(value="allowTabletSearchOutsideWorld")
        @Config.LangKey(value="tombstone.config.allow_tablet_search_outside_world")
        @Config.Comment(value={"Allows lost tablets to find locations outside the current world"})
        public boolean allowTabletSearchOutsideWorld = true;
        @Config.Name(value="cooldownResetperk")
        @Config.LangKey(value="tombstone.config.cooldown_reset_perk")
        @Config.Comment(value={"The cooldown in minutes to reset the perks with the \u00c3\u201ankh of Pray"})
        @Config.RangeInt(min=0, max=60)
        public int cooldownResetperk = 20;
        @Config.Name(value="cooldownToPray")
        @Config.LangKey(value="tombstone.config.cooldown_to_pray")
        @Config.Comment(value={"The cooldown in hours to pray with the \u00c3\u201ankh of Pray"})
        @Config.RangeInt(min=1, max=10)
        public int cooldownToPray = 3;
        static int serverCooldownToPray = 3;
        @Config.Name(value="blackListCapturableSouls")
        @Config.LangKey(value="tombstone.config.black_list_capturable_souls")
        @Config.Comment(value={"The creatures that can't be captured in receptacle"})
        public String[] blackListCapturableSouls = new String[0];

        public int getTabletMaxUse() {
            return serverTabletMaxUse;
        }

        public boolean isUnbreakableDecorativeGrave() {
            return serverUnbreakableDecorativeGrave;
        }

        public int getCooldownToPray() {
            return serverCooldownToPray;
        }
    }

    public static class CatEnchantments {
        @Config.Name(value="restrictShadowStepToPlayer")
        @Config.LangKey(value="tombstone.config.restrict_shadow_step_to_player")
        @Config.Comment(value={"Restricts the effect of Shadow Step to players"})
        public boolean restrictShadowStepToPlayer = true;
        @Config.Name(value="nerfShadowStep")
        @Config.LangKey(value="tombstone.config.nerf_shadow_step")
        @Config.Comment(value={"Shadow Step is only active while sneaking"})
        public boolean nerfShadowStep = false;
        static boolean serverNerfShadowStep = false;
        @Config.Name(value="enableEnchantmentShadowStep")
        @Config.LangKey(value="tombstone.config.enable_enchantment_shadow_step")
        @Config.Comment(value={"Enables the enchantment Shadow Step"})
        public boolean enableEnchantmentShadowStep = true;
        static boolean serverEnableEnchantmentShadowStep = true;
        @Config.Name(value="enableEnchantmentSoulbound")
        @Config.LangKey(value="tombstone.config.enable_enchantment_soulbound")
        @Config.Comment(value={"Enables the enchantment Soulbound"})
        public boolean enableEnchantmentSoulbound = true;
        static boolean serverEnableEnchantmentSoulbound = true;
        @Config.Name(value="enableEnchantmentMagicSiphon")
        @Config.LangKey(value="tombstone.config.enable_enchantment_magic_siphon")
        @Config.Comment(value={"Enables the enchantment Magic Siphon"})
        public boolean enableEnchantmentMagicSiphon = true;
        static boolean serverEnableEnchantmentMagicSiphon = true;
        @Config.Name(value="enableEnchantmentPlagueBringer")
        @Config.LangKey(value="tombstone.config.enable_enchantment_plague_bringer")
        @Config.Comment(value={"Enables the enchantment Plague Bringer"})
        public boolean enableEnchantmentPlagueBringer = true;
        static boolean serverEnableEnchantmentPlagueBringer = true;
        @Config.Name(value="nerfPlagueBringer")
        @Config.LangKey(value="tombstone.config.nerf_plague_bringer")
        @Config.Comment(value={"The wearer is also affected by the effect if his alignment is not bad"})
        public boolean nerfPlagueBringer = true;

        public boolean isNerfShadowStep() {
            return serverNerfShadowStep;
        }

        public boolean isEnableEnchantmentShadowStep() {
            return serverEnableEnchantmentShadowStep;
        }

        public boolean isEnableEnchantmentSoulbound() {
            return serverEnableEnchantmentSoulbound;
        }

        public boolean isEnableEnchantmentMagicSiphon() {
            return serverEnableEnchantmentMagicSiphon;
        }

        public boolean isEnableEnchantmentPlagueBringer() {
            return serverEnableEnchantmentPlagueBringer;
        }
    }

    public static class CatVillageSiege {
        @Config.Name(value="handleVillageSiege")
        @Config.LangKey(value="tombstone.config.handle_village_siege")
        @Config.Comment(value={"Allows to handle village sieges"})
        @Config.RequiresWorldRestart
        public boolean handleVillageSiege = true;
        @Config.Name(value="logSiegeState")
        @Config.LangKey(value="tombstone.config.log_siege_state")
        @Config.Comment(value={"Logs the different states of a village siege while searching for an adequate place"})
        public boolean logSiegeState = false;
        @Config.Name(value="deniedDimensionTypeForSiege")
        @Config.LangKey(value="tombstone.config.denied_dimension_type_for_siege")
        @Config.Comment(value={"The dimensions that village sieges should not occur in"})
        @Config.RequiresWorldRestart
        public String[] deniedDimensionTypeForSiege = new String[]{"the_nether", "the_end"};
        @Config.Name(value="allowCreativePlayersForSiege")
        @Config.LangKey(value="tombstone.config.allow_creative_players_for_siege")
        @Config.Comment(value={"Allows to use the positions of creative players to define the siege location"})
        public boolean allowCreativePlayersForSiege = false;
        @Config.Name(value="siegeChance")
        @Config.LangKey(value="tombstone.config.siege_chance")
        @Config.Comment(value={"Chance for a siege to occur"})
        @Config.RangeInt(min=0, max=100)
        public int siegeChance = 10;
        @Config.Name(value="siegeMinDoor")
        @Config.LangKey(value="tombstone.config.siege_min_door")
        @Config.Comment(value={"Minimum of doors for a siege"})
        @Config.RangeInt(min=0, max=50)
        public int siegeMinDoor = 10;
        @Config.Name(value="siegeMinVillager")
        @Config.LangKey(value="tombstone.config.siege_min_villager")
        @Config.Comment(value={"Minimum of villagers for a siege"})
        @Config.RangeInt(min=0, max=50)
        public int siegeMinVillager = 20;
        @Config.Name(value="siegeMinGolem")
        @Config.LangKey(value="tombstone.config.siege_min_golem")
        @Config.Comment(value={"Minimum of golems for a siege"})
        @Config.RangeInt(min=0, max=5)
        public int siegeMinGolem = 0;
        @Config.Name(value="siegeMaxCreature")
        @Config.LangKey(value="tombstone.config.siege_max_creature")
        @Config.Comment(value={"Maximum of creatures appearing in a siege"})
        @Config.RangeInt(min=0, max=100)
        public int siegeMaxCreature = 20;
        @Config.Name(value="undeadWearHelmInSiege")
        @Config.LangKey(value="tombstone.config.undead_wear_helm_in_siege")
        @Config.Comment(value={"Undeads always wear a helm when sieging"})
        public boolean undeadWearHelmInSiege = true;
        @Config.Name(value="delaySiegeTest")
        @Config.LangKey(value="tombstone.config.delay_siege_test")
        @Config.Comment(value={"Delay in seconds for a second test of siege when the first failed"})
        @Config.RangeInt(min=0, max=2400)
        public int delaySiegeTest = 600;
        @Config.Name(value="persistentMobInSiege")
        @Config.LangKey(value="tombstone.config.persistent_mob_in_siege")
        @Config.Comment(value={"Mobs in siege are persistent"})
        public boolean persistentMobInSiege = false;
        @Config.Name(value="shufflePlayersForSiege")
        @Config.LangKey(value="tombstone.config.shuffle_players_for_siege")
        @Config.Comment(value={"Shuffles the list of players before testing the siege location"})
        public boolean shufflePlayersForSiege = true;
        @Config.Name(value="glowingCreatureTest")
        @Config.LangKey(value="tombstone.config.glowing_creature_test")
        @Config.Comment(value={"The creatures of the siege have a glowing effect (only uses this for test purposes)"})
        public boolean glowingCreatureTest = false;
    }

    public static class CatCompatibilities {
        @Config.Name(value="allowBaublesAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_baubles_autoEquip")
        @Config.Comment(value={"Allows to re-equip the Baubles slots"})
        public boolean allowBaublesAutoEquip = true;
        @Config.Name(value="allowGalacticrafAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_galacticraf_autoEquip")
        @Config.Comment(value={"Allows to re-equip Galacticraft slots"})
        public boolean allowGalacticrafAutoEquip = true;
        @Config.Name(value="allowTechgunsAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_techguns_autoEquip")
        @Config.Comment(value={"Allows to re-equip Techguns slots"})
        public boolean allowTechgunsAutoEquip = true;
        @Config.Name(value="allowAetherLegacyAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_aether_legacy_autoEquip")
        @Config.Comment(value={"Allows to re-equip Aether Legacy slots"})
        public boolean allowAetherLegacyAutoEquip = false;
        @Config.Name(value="allowRPGInventoryAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_rpg_inventory_autoEquip")
        @Config.Comment(value={"Allows to re-equip RPG Inventory slots"})
        public boolean allowRPGInventoryAutoEquip = true;
        @Config.Name(value="allowTheBetweenLandsAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_the_between_lands_autoEquip")
        @Config.Comment(value={"Allows to re-equip The BetweenLands slots"})
        public boolean allowTheBetweenLandsAutoEquip = true;
        @Config.Name(value="allowSmartBackpacksAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_smart_backpacks_autoEquip")
        @Config.Comment(value={"Allows to re-equip the backpack slot"})
        public boolean allowSmartBackpacksAutoEquip = true;
        @Config.Name(value="supportWearableBackpacks")
        @Config.LangKey(value="tombstone.config.support_wearable_backpacks")
        @Config.Comment(value={"Allows to move the backpack close to the grave"})
        public boolean supportWearableBackpacks = false;
        @Config.Name(value="keepCosmeticArmor")
        @Config.LangKey(value="tombstone.config.keep_cosmetic_armor")
        @Config.Comment(value={"Keeps the cosmetic armor when you die"})
        public boolean keepCosmeticArmor = true;
        @Config.Name(value="allowThaumcraftVisValues")
        @Config.LangKey(value="tombstone.config.allow_thaumcraft_vis_values")
        @Config.Comment(value={"Allows to provide some vis values for decorative graves"})
        public boolean allowThaumcraftVisValues = false;
    }

    public static class CatClient {
        @Config.Name(value="equipElytraInPriority")
        @Config.LangKey(value="tombstone.config.equip_elytra_in_priority")
        @Config.Comment(value={"Equips elytra in priority when recovering your lost items"})
        public boolean equipElytraInPriority = false;
        public static boolean lastEquipElytraInPriority;
        @Config.Name(value="favoriteGrave")
        @Config.LangKey(value="tombstone.config.favorite_grave")
        @Config.Comment(value={"Favorite grave"})
        public GraveModel favoriteGrave = GraveModel.GRAVE_SIMPLE;
        public static GraveModel lastFavoriteGrave;
        @Config.Name(value="highlight")
        @Config.LangKey(value="tombstone.config.highlight")
        @Config.Comment(value={"Highlights the tomb from far when holding the key"})
        public boolean highlight = true;
        @Config.Name(value="fogDensity")
        @Config.LangKey(value="tombstone.config.fog_density")
        @Config.Comment(value={"Fog density around the graves"})
        public FogDensity fogDensity = FogDensity.LOW;
        @Config.Name(value="showShadowStep")
        @Config.LangKey(value="tombstone.config.show_shadow_step")
        @Config.Comment(value={"Shows shadow step particles"})
        public boolean showShadowStep = true;
        @Config.Name(value="textColorRIP")
        @Config.LangKey(value="tombstone.config.text_color_rip")
        @Config.Comment(value={"Decimal value for the color of the grave text <R.I.P.>"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int textColorRIP = 2962496;
        @Config.Name(value="textColorOwner")
        @Config.LangKey(value="tombstone.config.text_color_owner")
        @Config.Comment(value={"Decimal value for the color of the grave text <Owner Name>"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int textColorOwner = 5991302;
        @Config.Name(value="textColorDeathDate")
        @Config.LangKey(value="tombstone.config.text_color_death_date")
        @Config.Comment(value={"Decimal value for the color of the grave text <Death Date>"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int textColorDeathDate = 2962496;
        @Config.Name(value="particleCastingColor")
        @Config.LangKey(value="tombstone.config.particle_casting_color")
        @Config.Comment(value={"Decimal value for the color of the particles when using magic items"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int particleCastingColor = 14937088;
        @Config.Name(value="showMagicCircle")
        @Config.LangKey(value="tombstone.config.show_magic_circle")
        @Config.Comment(value={"Shows the magic circles"})
        public boolean showMagicCircle = true;
        @Config.Name(value="skipRespawnScreen")
        @Config.LangKey(value="tombstone.config.skip_respawn_screen")
        @Config.Comment(value={"Skips the Respawn Screen"})
        public boolean skipRespawnScreen = false;
        @Config.Name(value="showEnhancedTooltips")
        @Config.LangKey(value="tombstone.config.show_enhanced_tooltips")
        @Config.Comment(value={"Shows all the infos in the tooltip of items"})
        public boolean showEnhancedTooltips = true;
        @Config.Name(value="dateInMCTime")
        @Config.LangKey(value="tombstone.config.date_in_mc_time")
        @Config.Comment(value={"Shows only the elapsed minecraft days since the death on graves"})
        public boolean dateInMCTime = false;
        @Config.Name(value="displayKnowledgeMessage")
        @Config.LangKey(value="tombstone.config.display_knowledge_message")
        @Config.Comment(value={"Display or not the messages of gain of points in knowledge of death"})
        public boolean displayKnowledgeMessage = false;
        public static boolean lastDisplayKnowledgeMessage;
        @Config.Name(value="enableHalloweenEffect")
        @Config.LangKey(value="tombstone.config.enable_halloween_effect")
        @Config.Comment(value={"Enables the special rendering and particles for Halloween"})
        public boolean enableHalloweenEffect = true;
        @Config.Name(value="showInfoOnEnchantment")
        @Config.LangKey(value="tombstone.config.show_info_on_enchantment")
        @Config.Comment(value={"Shows the use of the Tombstone's enchantments in tooltip"})
        public boolean showInfoOnEnchantment = true;
        @Config.Name(value="graveSkinRule")
        @Config.LangKey(value="tombstone.config.grave_skin_rule")
        @Config.Comment(value={"Defines the rule to use for grave's skin"})
        public GraveSkinRule graveSkinRule = GraveSkinRule.DEFAULT;

        public static enum GraveSkinRule {
            DEFAULT,
            FORCE_NORMAL,
            FORCE_HALLOWEEN;

        }

        public static enum FogDensity {
            NONE,
            LOW,
            NORMAL,
            HIGH;

        }
    }
}

