/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBRequestTeleport
extends TombstoneCommand {
    private static final List<Ticket> ticketList = new ArrayList<Ticket>();

    public String func_71517_b() {
        return "tbrequestteleport";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandTBRequestTeleport.func_71521_c((ICommandSender)sender);
        EntityPlayerMP target = server.func_184103_al().func_177451_a(UUID.fromString(args[0]));
        if (target == null) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_INVALID_PLAYER.getKey(), new Object[0]);
        }
        boolean valid = ticketList.removeIf(p -> ((Ticket)p).playerUUID.equals(player.func_110124_au()) && ((Ticket)p).targetUUID.equals(target.func_110124_au()) && ((Ticket)p).expiredTime >= TimeHelper.systemTime());
        if (!valid) {
            throw new CommandException(LangKey.MESSAGE_NO_TICKET.getKey(), new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(player.func_71121_q(), player.func_180425_c()).findSafePlace(3, true, true);
        EntityPlayerMP newPlayer = Helper.teleportEntity(target, spawnLoc.isOrigin() ? new Location((Entity)player) : spawnLoc);
        LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newPlayer, new Object[0]);
        LangKey.MESSAGE_JOIN_YOU.sendSpecialMessage((ICommandSender)player, newPlayer.func_70005_c_());
    }

    public static void addTicket(EntityPlayer player, EntityPlayer target, int duration) {
        ticketList.add(new Ticket(player.func_110124_au(), target.func_110124_au(), TimeHelper.systemTime() + TimeUnit.SECONDS.toMillis(duration)));
    }

    public static void cleanTickets(long time) {
        ticketList.removeIf(p -> ((Ticket)p).expiredTime < time);
    }

    public static class Ticket {
        private final UUID playerUUID;
        private final UUID targetUUID;
        private long expiredTime;

        Ticket(UUID playerUUID, UUID targetUUID, long expiredTime) {
            this.playerUUID = playerUUID;
            this.targetUUID = targetUUID;
            this.expiredTime = expiredTime;
        }
    }
}

