/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEnchantments;

public class EnchantmentPlagueBringer
extends TombstoneEnchantment {
    private boolean allowedForThisPlayer = true;

    public EnchantmentPlagueBringer() {
        super("plague_bringer", Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
    }

    @Override
    protected boolean isEnabled() {
        return ConfigTombstone.enchantments.isEnableEnchantmentPlagueBringer();
    }

    @Override
    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantments.magic_siphon;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    @Override
    public int func_77325_b() {
        return 3;
    }

    public void func_151368_a(EntityLivingBase attacker, Entity entity, int level) {
        boolean isPlayerAttacker = EntityHelper.isValidPlayerMP((Entity)attacker);
        if (isPlayerAttacker && (this.allowedForThisPlayer = !this.allowedForThisPlayer)) {
            return;
        }
        if (Helper.random.nextFloat() < (float)level * 0.1f) {
            PotionEffect effect;
            boolean canAffectTarget;
            boolean canAffectAttacker = ConfigTombstone.enchantments.nerfPlagueBringer && (!isPlayerAttacker || !EntityHelper.isBadAlignment((EntityPlayerMP)attacker));
            boolean bl = canAffectTarget = entity.func_70089_S() && entity instanceof EntityLivingBase;
            if ((canAffectAttacker || canAffectTarget) && (effect = Helper.getRandomEffect(100, true)) != null) {
                if (canAffectTarget) {
                    ((EntityLivingBase)entity).func_70690_d(effect);
                }
                if (canAffectAttacker) {
                    attacker.func_70690_d(effect);
                }
            }
        }
    }
}

