/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer {
    public ItemAnkhOfPray() {
        super("ankh_of_pray", true, false, false);
        this.func_77625_d(1);
        this.func_77656_e(10);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            ITBCapability cap;
            this.addItemDesc(list);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null) {
                if (!this.func_77636_d(stack)) {
                    int cd = cap.getCooldownToPray((EntityPlayer)player) / 20;
                    if (cd > 0) {
                        long hour = cd / 3600;
                        String timeString = "";
                        if (hour > 0L) {
                            cd = (int)((long)cd - hour * 3600L);
                            timeString = String.format("%02d", hour) + ":";
                        }
                        timeString = timeString + String.format("%02d", cd / 60) + ":" + String.format("%02d", cd % 60);
                        this.addItemUse(list, "1", StyleType.TOOLTIP_DESC.func_150218_j() + " [" + timeString + "]");
                    }
                } else {
                    this.addItemUse(list, "2", new Object[0]);
                }
                if (cap.canResetPerks((EntityPlayer)player)) {
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        } else {
            this.addInfoShowTooltip(list);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockGraveBase && ((Boolean)state.func_177229_b((IProperty)BlockGraveBase.HAS_SOUL)).booleanValue()) {
            return EnumActionResult.PASS;
        }
        if (player != null) {
            this.func_77659_a(world, player, hand);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (EntityHelper.isValidPlayer(playerIn) && !playerIn.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && playerIn.func_184614_ca().func_77973_b() == this && !EntityHelper.hasCooldown(playerIn, this)) {
            ITBCapability cap;
            EntityHelper.setCooldown(playerIn, this, 10);
            EntityPlayerMP player = (EntityPlayerMP)playerIn;
            if (target instanceof EntityZombieVillager && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null && cap.canPray((EntityPlayer)player)) {
                EntityZombieVillager villager = (EntityZombieVillager)target;
                EntityHelper.addPotion((EntityLivingBase)villager, ModEffects.exorcism, 200, 1, new boolean[0]);
                villager.field_191992_by = null;
                villager.field_82234_d = 200;
                villager.func_184212_Q().func_187227_b(EntityZombieVillager.field_184739_bx, (Object)Boolean.TRUE);
                villager.func_184589_d(MobEffects.field_76437_t);
                villager.field_70170_p.func_72960_a((Entity)villager, (byte)16);
                cap.resetNextPray((EntityPlayer)player);
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), player);
                EntityHelper.addKnowledge(player, 3L);
                EntityHelper.addAlignment(player, 1);
                stack.func_77972_a(3, (EntityLivingBase)player);
                LangKey.MESSAGE_EXORCISM.sendSpecialMessage((ICommandSender)player, new Object[0]);
                ModTriggers.EXORCISM.trigger(player);
                return true;
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ITBCapability cap;
        ItemStack heldStack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && heldStack.func_77973_b() == this && !player.func_184811_cZ().func_185141_a((Item)this) && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null && cap.canPray(player)) {
            ITextComponent failedMessage = null;
            ItemStack offhand = player.func_184592_cb();
            if (ModItems.familiar_receptacle.containSoul(offhand)) {
                if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhand) != 0.0) {
                    failedMessage = LangKey.MESSAGE_RECOVERING_RECEPTACLE.getTranslationWithStyle(StyleType.COLOR_OFF, new Object[0]);
                } else if (cap.getTotalPerkPoints() < 10) {
                    failedMessage = LangKey.MESSAGE_KNOWLEDGE_REQUIRED.getTranslationWithStyle(StyleType.COLOR_OFF, 10);
                }
                if (failedMessage != null) {
                    player.func_184811_cZ().func_185145_a((Item)this, 10);
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_145747_a(failedMessage);
                    }
                    return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
                }
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldStack);
    }

    @Nullable
    private BlockPos findGraveAround(World world, BlockPos startPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currentPos = new BlockPos(startPos.func_177958_n() + x, startPos.func_177956_o() + y, startPos.func_177952_p() + z);
                    if (!(world.func_180495_p(currentPos).func_177230_c() instanceof BlockDecorativeGrave)) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, @Nullable World world, EntityLivingBase entity) {
        EntityPlayerMP player;
        if (EntityHelper.isValidPlayerMP((Entity)entity) && !EntityHelper.hasCooldown((EntityPlayer)(player = (EntityPlayerMP)entity), this)) {
            BlockPos gravePos = this.findGraveAround(player.field_70170_p, player.func_180425_c());
            if (gravePos != null) {
                ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
                if (cap != null) {
                    ItemStack offhandStack = player.func_184592_cb();
                    if (offhandStack.func_77973_b() == ModItems.familiar_receptacle) {
                        if (ModItems.familiar_receptacle.containSoul(offhandStack)) {
                            if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhandStack) > 0.0) {
                                LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendWarnMessage((ICommandSender)player, new Object[0]);
                            } else if (ModItems.familiar_receptacle.revive((EntityPlayer)player, gravePos, offhandStack)) {
                                cap.resetNextPray((EntityPlayer)player);
                                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), player);
                                cap.addKnowledgeAndSync(player, 5L);
                                stack.func_77972_a(1, (EntityLivingBase)player);
                                ModTriggers.REVIVE_FAMILIAR.trigger(player);
                                LangKey.MESSAGE_REVIVE_FAMILIAR.sendSpecialMessage((ICommandSender)player, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR});
                                offhandStack.func_190918_g(1);
                            } else {
                                NBTTagCompound tag = offhandStack.func_77978_p();
                                if (tag != null) {
                                    tag.func_82580_o("dead_pet");
                                }
                                LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.sendWarnMessage((ICommandSender)player, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR});
                            }
                        } else {
                            LangKey.MESSAGE_EMPTY_RECEPTACLE.sendWarnMessage((ICommandSender)player, new Object[0]);
                        }
                    } else {
                        cap.resetNextPray((EntityPlayer)player);
                        PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), player);
                        cap.addKnowledgeAndSync(player, 1L);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        ModTriggers.FIRST_PRAY.trigger(player);
                        if (Helper.isDateAroundHalloween(player.field_70170_p) || Helper.getRandom(1, 100) < ConfigTombstone.decorativeGrave.chancePrayReward + cap.getTotalPerkPoints()) {
                            Helper.addRandomPotion((EntityPlayer)player, ConfigTombstone.decorativeGrave.getCooldownToPray() * 5000, true);
                        }
                    }
                }
            } else {
                LangKey.MESSAGE_CANT_PRAY.sendWarnMessage((ICommandSender)player, new Object[0]);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        if (entity != null && entity.field_70170_p.field_72995_K && timeLeft == this.func_77626_a(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        int cooldownToPray;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (EntityHelper.hasCooldown((EntityPlayer)player, stack)) {
            return false;
        }
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        int n = cooldownToPray = cap != null ? cap.getCooldownToPray((EntityPlayer)player) : 0;
        if (cooldownToPray > 0) {
            int maxTime = cap.getMaxPrayTime((EntityPlayer)player);
            int elapsedTime = maxTime - cooldownToPray;
            CooldownTracker cd = player.func_184811_cZ();
            cd.field_185148_b -= elapsedTime;
            cd.func_185145_a((Item)this, maxTime);
            cd.field_185148_b += elapsedTime;
            return false;
        }
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K) {
            ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
            return cap != null && cap.resetPerksAndSync((EntityPlayerMP)player);
        }
        return false;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_PERK_RESET_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        long cd;
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap != null && (cd = cap.getCooldownToResetPerks(player)) > 0L) {
            int min = (int)(cd / 1200L);
            if (min > 0) {
                cd -= (long)(min * 1200);
            }
            return LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getTranslation(min, cd / 20L);
        }
        return LangKey.MESSAGE_PERK_RESET_FAILED.getTranslation(new Object[0]);
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

