/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModEffects;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer {
    public ItemVoodooPoppet() {
        super("voodoo_poppet", true, false, false);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getServerTranslation(name) : name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            boolean hasProt = false;
            for (PoppetProtections prot : PoppetProtections.values()) {
                if (!this.hasProtection(stack, prot)) continue;
                list.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_ITEM, "tombstone.item." + this.name + "." + prot.getName(), new Object[0]));
                hasProt = true;
            }
            this.addItemUse(list, "" + (this.isEnchanted(stack) ? 3 : (hasProt ? 2 : 1)), new Object[0]);
            if (EntityHelper.getPerkLevelWithBonus((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ModPerks.voodoo_poppet) <= 0) {
                this.addWarn(list, LangKey.MESSAGE_PERK_REQUIRED, LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_ITEM, ModPerks.voodoo_poppet.getTranslationKey(), new Object[0]));
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.isAllowedVoodooPoppet();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_NO_PROTECTION_TO_SEAL.getTranslation(new Object[0]);
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!this.isEnchanted(stack) && Arrays.stream(PoppetProtections.values()).anyMatch(p -> this.hasProtection(stack, (PoppetProtections)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return true;
        }
        return false;
    }

    public ItemStack addProtection(ItemStack stack, PoppetProtections prot) {
        if (stack.func_77973_b() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, prot)) {
            NBTStackHelper.setBoolean(stack, "poppet_prot_" + prot.ordinal(), true);
        }
        return stack;
    }

    private boolean hasProtection(ItemStack stack, PoppetProtections prot) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "poppet_prot_" + prot.ordinal());
    }

    private boolean removeProtection(ItemStack stack, PoppetProtections prot) {
        return NBTStackHelper.removeKeyName(stack, "poppet_prot_" + prot.ordinal());
    }

    public boolean preventDeath(EntityPlayer player, ItemStack stack, PoppetProtections prot) {
        if (this.canPreventDeath(stack, prot) && this.removeProtection(stack, prot)) {
            NBTStackHelper.setBoolean(stack, "enchant", false);
            switch (prot) {
                case DROWN: {
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76427_o, 1200, 1, new boolean[0]);
                    break;
                }
                case BURN: {
                    player.func_70066_B();
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76426_n, 1200, 1, new boolean[0]);
                    break;
                }
                case STARVE: {
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, 1200, 1, new boolean[0]);
                    break;
                }
                case FALL: {
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addPotion((EntityLivingBase)player, ModEffects.feather_fall, 1200, 1, new boolean[0]);
                    break;
                }
                case WITHER: {
                    EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addPotion((EntityLivingBase)player, ModEffects.purification, 1200, 1, new boolean[0]);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean canPreventDeath(ItemStack stack, PoppetProtections prot) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, "poppet_prot_" + prot.ordinal());
    }

    @Nullable
    public PoppetProtections getPoppetProtections(DamageSource srcDmg) {
        return Arrays.stream(PoppetProtections.values()).filter(p -> ((PoppetProtections)p).srcDmg.contains(srcDmg)).findFirst().orElse(null);
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }

    public static enum PoppetProtections {
        DROWN(LangKey.MESSAGE_PREVENT_DEATH_DROWN, DamageSource.field_76369_e),
        BURN(LangKey.MESSAGE_PREVENT_DEATH_BURN, DamageSource.field_76371_c, DamageSource.field_76372_a, DamageSource.field_76370_b),
        STARVE(LangKey.MESSAGE_PREVENT_DEATH_STARVE, DamageSource.field_76366_f),
        FALL(LangKey.MESSAGE_PREVENT_DEATH_FALL, DamageSource.field_76379_h),
        WITHER(LangKey.MESSAGE_PREVENT_DEATH_WITHER, DamageSource.field_82727_n);

        private final LangKey key;
        private final List<DamageSource> srcDmg;

        private PoppetProtections(LangKey key, DamageSource ... srcDmg) {
            this.key = key;
            this.srcDmg = Arrays.asList(srcDmg);
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public LangKey getLangKey() {
            return this.key;
        }

        public static PoppetProtections getRandomProtection() {
            return PoppetProtections.values()[Helper.getRandom(0, PoppetProtections.values().length - 1)];
        }
    }
}

