/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.IntegrationTOP;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.ServerModConfig;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod(value="tombstone")
public class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final EnchantmentType TYPE_TOMBSTONE_ALL = Helper.addEnchantmentType("type_tombstone_all", p -> p != null && (p.func_77619_b() > 0 || p.func_77639_j() == 1), EnchantmentType.ALL);

    public ModTombstone() {
        Reflection.initialize((Class[])new Class[]{PerkRegistry.class, PacketHandler.class, ModTriggers.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, ConfigTombstone.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, ConfigTombstone.GENERAL_SPEC);
        this.registerSharedConfig(context.getActiveContainer());
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::preInit);
        eventBus.addListener(this::enqueueIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> GuiConfig::new);
    }

    private void registerSharedConfig(ModContainer container) {
        container.addConfig((ModConfig)new ServerModConfig(SharedConfigTombstone.CONFIG_SPEC, container));
    }

    private void preInit(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        CapabilityManager.INSTANCE.register(ISoulConsumer.class, Helper.getNullStorage(), TBSoulConsumerProvider::getDefault);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)Helper.buildKnowledgeFunction());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)InOpenWaterCondition.SERIALIZER);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (SupportMods.TOP.isLoaded()) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", IntegrationTOP::new);
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        if (SupportMods.GRAVESTONE.isLoaded()) {
            throw new RuntimeException("Corail Tombstone Exception : you loaded an incompatible grave mod : GraveStone");
        }
        if (SupportMods.CORPSE.isLoaded()) {
            throw new RuntimeException("Corail Tombstone Exception : you loaded an incompatible grave mod : Corpse");
        }
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        Helper.initCommands((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        MinecraftForge.EVENT_BUS.register((Object)new CallbackHandler());
        Helper.loadContributors(event.getServer());
    }

    @SubscribeEvent
    public void onServerStoppingEvent(FMLServerStoppingEvent event) {
        CallbackHandler.clear();
        DeathHandler.INSTANCE.clear();
    }
}

