/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public class TBCapabilityDefault
implements ITBCapability {
    protected long knowledge = 0L;
    private final Map<Perk, Integer> perks = new HashMap<Perk, Integer>();
    private long nextPray = -1L;
    private long nextResetPerks = -1L;
    private long nextRequestTeleport = -1L;
    private long nextTeleportDeath = -1L;
    private long nextTeleportBind = -1L;
    protected int alignment = 0;
    protected int alignmentLevel = 0;

    @Override
    public long getKnowledge() {
        return this.knowledge;
    }

    @Override
    public ITBCapability setKnowledge(long points) {
        this.knowledge = Math.max(0L, points);
        return this;
    }

    @Override
    public ITBCapability addKnowledgeAndSync(ServerPlayerEntity player, long points) {
        if (!player.field_70170_p.field_72995_K && points > 0L) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.knowledge += points;
            if (DeathHandler.INSTANCE.getOptionKnowledgeMessage(player.func_110124_au())) {
                player.func_145747_a(LangKey.MESSAGE_EARN_KNOWLEDGE.getTranslationWithStyle(StyleType.MESSAGE_SPELL, LangKey.MESSAGE_YOUR_KNOWLEDGE.getTranslation(), points));
                int newPerkPoints = this.getTotalPerkPoints();
                int adjust = newPerkPoints - oldPerkPoints;
                if (adjust > 0) {
                    player.func_145747_a(LangKey.MESSAGE_ACCESS_GUI.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, adjust, LangKey.createComponentCommand((PlayerEntity)player, "/tbgui", LangKey.MESSAGE_HERE, new Object[0])));
                    if (oldPerkPoints == 0) {
                        ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                    }
                    if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                        ModTriggers.MASTERY_1.trigger(player);
                    }
                }
            }
            PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
        }
        return this;
    }

    @Override
    public ITBCapability removeKnowledgeAndSync(ServerPlayerEntity player, long points) {
        if (!player.field_70170_p.field_72995_K) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (PlayerEntity)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.nextPray, this.alignment, this.perks), player);
            } else {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            }
            if (DeathHandler.INSTANCE.getOptionKnowledgeMessage(player.func_110124_au())) {
                player.func_145747_a(LangKey.MESSAGE_LOSE_KNOWLEDGE.getTranslationWithStyle(StyleType.MESSAGE_SPELL, LangKey.MESSAGE_YOUR_KNOWLEDGE.getTranslation(), points));
            }
        }
        return this;
    }

    @Override
    public long getKnowledgeForLevel(int level) {
        return level <= 0 ? 0L : (long)(level * level * 2);
    }

    @Override
    public long getKnowledgeToReachNextLevel(int level) {
        return level <= 0 ? 0L : (long)(4 * level - 2);
    }

    @Override
    public int getUsedPerkPoints(PlayerEntity player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            Perk perk = entry.getKey();
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += perk.getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)MathHelper.func_76129_c((float)((float)this.knowledge / 2.0f));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public ITBCapability setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ITBCapability setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
        return this;
    }

    @Override
    public boolean removePerk(Perk perk) {
        return this.perks.remove(perk) != null;
    }

    @Override
    public int getPerkLevel(PlayerEntity player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(PlayerEntity player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public int getCooldownToPray(PlayerEntity player) {
        int maxPrayTime;
        int cd = (int)(this.nextPray - TimeHelper.worldTicks(player.field_70170_p));
        if (cd > (maxPrayTime = this.getMaxPrayTime(player))) {
            this.resetNextPray(player);
            cd = maxPrayTime;
            if (!player.field_70170_p.field_72995_K) {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, this.getNextPray()), (ServerPlayerEntity)player);
            }
        }
        return cd;
    }

    @Override
    public ITBCapability resetNextPray(PlayerEntity player) {
        this.nextPray = TimeHelper.worldTicks(player.field_70170_p) + (long)this.getMaxPrayTime(player);
        return this;
    }

    @Override
    public int getMaxPrayTime(PlayerEntity player) {
        int ticks = TimeHelper.tickFromHour((Integer)SharedConfigTombstone.decorative_grave.cooldownToPray.get());
        return Helper.isContributor(player) ? ticks / 2 : ticks;
    }

    @Override
    public long getNextPray() {
        return this.nextPray;
    }

    @Override
    public ITBCapability setNextPray(long worldTime) {
        this.nextPray = worldTime;
        return this;
    }

    @Override
    public boolean canResetPerks(PlayerEntity player) {
        return this.getCooldownToResetPerks(player) <= 0L && this.perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled(player));
    }

    @Override
    public long getCooldownToResetPerks(PlayerEntity player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        int cd = (int)(this.nextResetPerks - worldTicks);
        if (cd > (maxResetTime = TimeHelper.tickFromMinute((Integer)ConfigTombstone.decorative_grave.cooldownResetPerk.get()))) {
            cd = maxResetTime;
            this.nextResetPerks = worldTicks + (long)maxResetTime;
        }
        return Math.max((long)cd, 0L);
    }

    @Override
    public boolean resetPerksAndSync(ServerPlayerEntity player) {
        if (!player.field_70170_p.field_72995_K && this.canResetPerks((PlayerEntity)player)) {
            this.setPerks(new HashMap<Perk, Integer>());
            this.nextResetPerks = TimeHelper.worldTicks(player.field_70170_p) + (long)TimeHelper.tickFromMinute((Integer)ConfigTombstone.decorative_grave.cooldownResetPerk.get());
            this.syncAll(player);
            return true;
        }
        return false;
    }

    @Override
    public ITBCapability setNextResetPerks(long worldTime) {
        this.nextResetPerks = worldTime;
        return this;
    }

    @Override
    public ITBCapability copyCapability(ITBCapability otherTBCapability) {
        this.deserializeNBT((CompoundNBT)otherTBCapability.serializeNBT());
        return this;
    }

    @Override
    public ITBCapability syncAll(ServerPlayerEntity player) {
        PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.nextPray, this.alignment, this.perks), player);
        return this;
    }

    @Override
    public ITBCapability setCooldownToRequestTeleport(long worldTime) {
        this.nextRequestTeleport = worldTime;
        return this;
    }

    @Override
    public int getCooldownToRequestTeleport(ServerPlayerEntity player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextRequestTeleport - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownRequestTeleport.get()))) {
            this.setCooldownToRequestTeleport(worldTicks + (long)maxResetTime);
            return maxResetTime;
        }
        return Math.max((int)cd, 0);
    }

    @Override
    public ITBCapability setCooldownToTeleportDeath(long worldTime) {
        this.nextTeleportDeath = worldTime;
        return this;
    }

    @Override
    public int getCooldownToTeleportDeath(ServerPlayerEntity player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextTeleportDeath - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportDeath.get()))) {
            this.setCooldownToTeleportDeath(worldTicks + (long)maxResetTime);
            return maxResetTime;
        }
        return Math.max((int)cd, 0);
    }

    @Override
    public ITBCapability setCooldownToTeleportBind(long worldTime) {
        this.nextTeleportBind = worldTime;
        return this;
    }

    @Override
    public int getCooldownToTeleportBind(ServerPlayerEntity player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextTeleportBind - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportBind.get()))) {
            this.setCooldownToTeleportBind(worldTicks + (long)maxResetTime);
            return maxResetTime;
        }
        return Math.max((int)cd, 0);
    }

    @Override
    public ITBCapability increaseAlignment(int amount) {
        if (amount > 0 && this.alignmentLevel < 0 || amount < 0 && this.alignmentLevel > 0) {
            amount *= 2;
        }
        return this.setAlignment(this.alignment + amount);
    }

    @Override
    public ITBCapability decreaseAlignment(int amount) {
        return this.increaseAlignment(-amount);
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -500;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 500;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= -500) {
            return -4;
        }
        if (this.alignment <= -300) {
            return -3;
        }
        if (this.alignment <= -150) {
            return -2;
        }
        if (this.alignment <= -50) {
            return -1;
        }
        if (this.alignment < 50) {
            return 0;
        }
        if (this.alignment < 150) {
            return 1;
        }
        if (this.alignment < 300) {
            return 2;
        }
        if (this.alignment < 500) {
            return 3;
        }
        return 4;
    }

    @Override
    public ITBCapability setAlignment(int value) {
        this.alignment = MathHelper.func_76125_a((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
        return this;
    }

    @Override
    public ITBCapability addAlignmentAndSync(ServerPlayerEntity player, int amount) {
        if (!player.field_70170_p.field_72995_K) {
            int oldAlignment = this.alignmentLevel;
            this.setAlignment(this.alignment + amount);
            if (oldAlignment != this.alignmentLevel) {
                this.onAlignmentLevelChange(oldAlignment, this.alignmentLevel);
            }
            PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALIGNMENT, this.alignment), player);
        }
        return this;
    }

    @Override
    public ITBCapability onAlignmentLevelChange(int oldAlignment, int newAlignment) {
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("knowledge", this.knowledge);
        nbt.func_74772_a("next_pray", this.nextPray);
        nbt.func_74772_a("next_reset_perks", this.nextResetPerks);
        nbt.func_74772_a("next_request_teleport", this.nextRequestTeleport);
        nbt.func_74772_a("next_teleport_death", this.nextTeleportDeath);
        nbt.func_74772_a("next_teleport_bind", this.nextTeleportBind);
        nbt.func_74768_a("alignment", this.alignment);
        ListNBT tagPerks = new ListNBT();
        this.perks.forEach((perk, value) -> {
            if (perk != null && !perk.isDisabled(null)) {
                CompoundNBT tagPerk = new CompoundNBT();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)perk));
                tagPerk.func_74768_a("level", Math.min(perk.getLevelMax(), value));
                tagPerks.add((Object)tagPerk);
            }
        });
        nbt.func_218657_a("perks", (INBT)tagPerks);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("knowledge", 4)) {
            this.knowledge = nbt.func_74763_f("knowledge");
        }
        if (nbt.func_150297_b("next_pray", 4)) {
            this.nextPray = nbt.func_74763_f("next_pray");
        }
        if (nbt.func_150297_b("next_reset_perks", 4)) {
            this.nextResetPerks = nbt.func_74763_f("next_reset_perks");
        }
        if (nbt.func_150297_b("next_request_teleport", 4)) {
            this.nextResetPerks = nbt.func_74763_f("next_request_teleport");
        }
        if (nbt.func_150297_b("next_teleport_death", 4)) {
            this.nextTeleportDeath = nbt.func_74763_f("next_teleport_death");
        }
        if (nbt.func_150297_b("next_teleport_bind", 4)) {
            this.nextTeleportBind = nbt.func_74763_f("next_teleport_bind");
        }
        if (nbt.func_150297_b("alignment", 3)) {
            this.setAlignment(nbt.func_74762_e("alignment"));
        }
        if (nbt.func_150297_b("perks", 9)) {
            ListNBT tagPerks = nbt.func_150295_c("perks", 10);
            IntStream.range(0, tagPerks.size()).mapToObj(arg_0 -> ((ListNBT)tagPerks).func_150305_b(arg_0)).filter(tagPerk -> tagPerk.func_150297_b("id", 3) && tagPerk.func_150297_b("level", 3)).forEach(tagPerk -> {
                Perk perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"));
                if (perk != null && !perk.isDisabled(null)) {
                    this.perks.put(perk, Math.min(perk.getLevelMax(), tagPerk.func_74762_e("level")));
                }
            });
        }
    }
}

