/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.registries.GameData;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

abstract class TombstoneCommand {
    private final CommandDispatcher<CommandSource> commandDispatcher;
    static final String TARGET_PARAM = "target";
    static final String BIOME_PARAM = "biome";
    static final String STRUCTURE_PARAM = "structure";
    static final String DIM_PARAM = "dim";
    static final SuggestionProvider<CommandSource> SUGGESTION_BIOME = (ctx, build) -> ISuggestionProvider.func_197014_a((Iterable)Registry.field_212624_m.func_148742_b(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> SUGGESTION_STRUCTURE = (ctx, build) -> ISuggestionProvider.func_197014_a((Iterable)GameData.getStructureFeatures().func_148742_b(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> SUGGESTION_DIM_IDS = (ctx, build) -> ISuggestionProvider.func_197013_a(DimensionManager.getRegistry().func_201756_e().map(dim -> String.valueOf(dim.func_186068_a())), (SuggestionsBuilder)build);

    public TombstoneCommand(CommandDispatcher<CommandSource> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    abstract String getName();

    public ITextComponent getUsage() {
        return new TranslationTextComponent("tombstone.command." + this.getName() + ".usage", new Object[0]);
    }

    public int getPermissionLevel() {
        return 2;
    }

    public int showUsage(CommandSource source) {
        source.func_197030_a(this.getUsage(), false);
        return 1;
    }

    abstract LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> var1);

    public void registerCommand() {
        LiteralArgumentBuilder<CommandSource> builder = this.getBuilder((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(p -> p.func_197034_c(this.getPermissionLevel()))));
        this.commandDispatcher.register(builder);
    }

    static void checkAlive(Entity entity) {
        if (!entity.func_70089_S()) {
            throw new CommandException(LangKey.MESSAGE_DEAD_ENTITY.getTranslation());
        }
    }

    static void checkNotSpectator(Entity entity) {
        if (entity instanceof PlayerEntity) {
            TombstoneCommand.checkNotSpectator((PlayerEntity)entity);
        }
    }

    static void checkNotSpectator(PlayerEntity player) {
        if (EntityHelper.isValidPlayer(player) && player.func_175149_v()) {
            throw new CommandException(LangKey.MESSAGE_PLAYER_SPECTATOR.getTranslation());
        }
    }

    static void checkValidPos(World world, BlockPos pos) {
        if (!Helper.isValidPos(world, pos)) {
            throw new CommandException(LangKey.MESSAGE_INVALID_LOCATION.getTranslation());
        }
    }

    DimensionType getOrThrowDimensionType(int dim) {
        DimensionType dimensionType = DimensionType.func_186069_a((int)dim);
        if (dimensionType == null) {
            throw new CommandException(LangKey.MESSAGE_NO_DIMENSION.getTranslation());
        }
        return dimensionType;
    }

    Biome getOrThrowBiome(CommandContext<CommandSource> context, String name) {
        ResourceLocation rl = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        return (Biome)Registry.field_212624_m.func_218349_b(rl).orElseThrow(() -> new CommandException(LangKey.MESSAGE_INVALID_BIOME.getTranslation()));
    }

    protected void sendMessage(CommandSource source, ITextComponent message, boolean allowLogging) {
        source.func_197030_a(message.func_150255_a(StyleType.TOOLTIP_DESC), allowLogging);
    }
}

