/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBBind;
import ovh.corail.tombstone.command.CommandTBKnownledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.CommandTBTeleportBiome;
import ovh.corail.tombstone.command.CommandTBTeleportDeath;
import ovh.corail.tombstone.command.CommandTBTeleportDiscovery;
import ovh.corail.tombstone.command.CommandTBTeleportGrave;
import ovh.corail.tombstone.command.CommandTBTeleportHome;
import ovh.corail.tombstone.compatibility.CompatibilityDruidCraft;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TeleportationHandler;
import ovh.corail.tombstone.helper.WorldFunctionInjector;
import ovh.corail.tombstone.registry.ModEnchantments;

public class Helper {
    public static final Random random = new Random();
    public static Boolean isHalloween = null;
    private static Boolean isAprilFools = null;
    public static boolean isContributor = false;
    private static ContributorStore CONTRIBUTORS = ContributorStore.of();
    private static final URL CONTRIBUTORS_URL;

    public static boolean isContributor(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return isContributor;
        }
        return CONTRIBUTORS.contains(player);
    }

    public static boolean isDisabledPerk(@Nullable Perk perk, @Nullable PlayerEntity player) {
        return perk == null || perk.isDisabled(player);
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    public static String dump(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static boolean existClass(String className) {
        return Helper.getClass(className) != null;
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> aClass, String methodName, Class<?> ... parameterTypes) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findMethod(aClass, (String)methodName, (Class[])parameterTypes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> List<T> iterableToList(Iterable<T> it) {
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return list;
    }

    public static int getDimensionId(IWorld world) {
        return Helper.getDimensionType(world).func_186068_a();
    }

    public static DimensionType getDimensionType(IWorld world) {
        return world.func_201675_m().func_186058_p();
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !World.func_189509_E((BlockPos)pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !World.func_189509_E((BlockPos)pos);
    }

    public static boolean isInvalidDimension(int dimId) {
        return DimensionManager.getRegistry().func_201756_e().noneMatch(dim -> dim.func_186068_a() == dimId);
    }

    @Nullable
    public static <T> T getRandomInList(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(random.nextInt(list.size()));
    }

    public static Pair<String, String> parseRLString(String rlString) {
        String[] splits = rlString.split(":");
        boolean noDomain = splits.length == 1;
        return noDomain ? Pair.of((Object)"minecraft", (Object)rlString) : Pair.of((Object)splits[0], (Object)splits[1]);
    }

    public static Location findNearestStructure(ServerWorld world, BlockPos pos, ResourceLocation structureRL, int y, boolean unexplored) {
        return Helper.findNearestStructure(world, pos, structureRL.toString(), y, unexplored);
    }

    public static Location findNearestStructure(ServerWorld world, BlockPos pos, String structureName, int y, boolean unexplored) {
        if (!world.func_72912_H().func_76089_r()) {
            return Location.ORIGIN;
        }
        BlockPos startingPos = pos;
        for (int nbTry = 0; nbTry < 5; ++nbTry) {
            startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177963_a((double)nbTry * random.nextGaussian() * 2000.0, 0.0, (double)nbTry * random.nextGaussian() * 2000.0));
            BlockPos foundPos = world.func_211157_a(SupportStructures.getStructureNameForSearch(structureName), startingPos, 100, unexplored);
            if (foundPos == null || !Helper.isValidPos((World)world, foundPos)) continue;
            return new Location(foundPos.func_177958_n(), y, foundPos.func_177952_p(), (IWorld)world);
        }
        return Location.ORIGIN;
    }

    public static Location findNearestStructure(ServerWorld world, BlockPos pos, String structureRLString, boolean unexplored) {
        return Helper.findNearestStructure(world, pos, structureRLString, pos.func_177956_o(), unexplored);
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        BlockState state;
        IChunk chunk = world.func_217349_x(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (!(blockpos.func_177956_o() < 0 || (state = chunk.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c() && state.func_185904_a() != Material.field_151584_j)) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public static Location findSpawnForVillage(ServerWorld world, BlockPos villagePos) {
        return new SpawnHelper(world, Helper.getTopSolidOrLiquidBlock((World)world, villagePos)).findSpawnPlace();
    }

    public static <T extends Entity> T teleportEntity(T entity, Location loc) {
        DimensionType dimType;
        MinecraftServer server;
        if (!entity.field_70170_p.field_72995_K && (server = entity.func_184102_h()) != null && (dimType = DimensionType.func_186069_a((int)loc.dim)) != null) {
            TeleportationHandler.teleportEntity(entity, dimType, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5);
        }
        return entity;
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc) {
        return Helper.teleportEntity(entity, new Location(loc.getPos().func_177984_a(), loc.dim));
    }

    public static boolean isRuleKeepInventory(PlayerEntity player) {
        return Helper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        Helper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, BlockState state) {
        pos = pos.func_185334_h();
        if (!((Boolean)ConfigTombstone.general.gravesBypassGriefingRules.get()).booleanValue()) {
            world.func_180501_a(pos, state, 3);
            return;
        }
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        Chunk chunk = (Chunk)world.func_217349_x(pos);
        ChunkSection[] storageArray = chunk.func_76587_i();
        ChunkSection chunksection = storageArray[j >> 4];
        if (chunksection == Chunk.field_186036_a) {
            if (state.func_196958_f()) {
                return;
            }
            storageArray[j >> 4] = chunksection = new ChunkSection(j >> 4 << 4);
        }
        boolean flag = chunksection.func_76663_a();
        BlockState blockstate = chunksection.func_222629_a(i, j & 0xF, k, state);
        if (blockstate != state) {
            Block block = state.func_177230_c();
            Block block1 = blockstate.func_177230_c();
            chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202270_a(i, j, k, state);
            chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(i, j, k, state);
            chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR).func_202270_a(i, j, k, state);
            chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE).func_202270_a(i, j, k, state);
            boolean flag1 = chunksection.func_76663_a();
            if (flag != flag1) {
                world.func_72863_F().func_212863_j_().func_215567_a(pos, flag1);
            }
            if (!world.field_72995_K) {
                blockstate.func_196947_b(world, pos, state, false);
            } else if (block1 != block && blockstate.hasTileEntity()) {
                world.func_175713_t(pos);
            }
            if (chunksection.func_177485_a(i, j & 0xF, k).func_177230_c() == block) {
                TileEntity tileentity;
                if (blockstate.hasTileEntity() && (tileentity = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK)) != null) {
                    tileentity.func_145836_u();
                }
                if (!world.field_72995_K) {
                    state.func_215705_a(world, pos, blockstate, false);
                }
                if (state.hasTileEntity()) {
                    TileEntity tileentity1 = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK);
                    if (tileentity1 == null) {
                        tileentity1 = state.createTileEntity((IBlockReader)world);
                        world.func_175690_a(pos, tileentity1);
                    } else {
                        tileentity1.func_145836_u();
                    }
                }
                chunk.func_76630_e();
            }
            int oldLight = blockstate.getLightValue((IEnviromentBlockReader)world, pos);
            int oldOpacity = blockstate.func_200016_a((IBlockReader)world, pos);
            if (state.func_200016_a((IBlockReader)world, pos) != oldOpacity || state.getLightValue((IEnviromentBlockReader)world, pos) != oldLight || state.func_215691_g() || blockstate.func_215691_g()) {
                world.func_72863_F().func_212863_j_().func_215568_a(pos);
            }
            world.markAndNotifyBlock(pos, chunk, blockstate, state, 3);
        }
    }

    public static boolean canShowTooltip(@Nullable World world, ItemStack stack) {
        return world != null && ((Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != false || Screen.hasShiftDown());
    }

    public static boolean isDateAroundHalloween() {
        return isHalloween != null && isHalloween != false;
    }

    public static boolean isDateAroundHalloween(LocalDate date) {
        if (isHalloween == null) {
            isHalloween = (Boolean)ConfigTombstone.general.persistantHalloween.get() != false || date.get(ChronoField.MONTH_OF_YEAR) == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3;
        }
        return isHalloween;
    }

    public static boolean isAprilFoolsDay() {
        if (isAprilFools == null) {
            LocalDate date = LocalDate.now();
            isAprilFools = date.get(ChronoField.MONTH_OF_YEAR) == 4 && date.get(ChronoField.DAY_OF_MONTH) == 1;
        }
        return isAprilFools;
    }

    public static boolean isNight(World world) {
        float angle = world.func_72826_c(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static boolean isDay(World world) {
        return !Helper.isNight(world);
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration, boolean isBad) {
        Effect potion;
        List potions = ForgeRegistries.POTIONS.getValues().stream().filter(isBad ? Helper::isBadEffect : Helper::isAllowedEffect).collect(Collectors.toList());
        if (potions.size() > 0 && (potion = (Effect)potions.get(random.nextInt(potions.size()))) != null) {
            int random = Helper.getRandom(1, 100);
            int level = random < 10 ? 4 : (random < 25 ? 3 : (random < 45 ? 2 : (random < 70 ? 1 : 0)));
            return new EffectInstance(potion, duration, level);
        }
        return null;
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage) {
        Helper.addRandomEffect(player, duration, withMessage, false);
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage, boolean isBad) {
        EffectInstance effect = Helper.getRandomEffect(duration, isBad);
        if (effect != null) {
            if (withMessage && !effect.func_188419_a().func_76393_a().isEmpty()) {
                player.func_145747_a(LangKey.MESSAGE_SPELL_CAST_ON_YOU.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new TranslationTextComponent(effect.func_188419_a().func_76393_a(), new Object[0]).func_150255_a(StyleType.MESSAGE_SPECIAL)));
            }
            EntityHelper.addEffect((LivingEntity)player, effect);
        }
    }

    public static boolean isBadEffect(@Nullable Effect effect) {
        return effect != null && effect.func_220303_e() == EffectType.HARMFUL && !Helper.containRL((List)ConfigTombstone.general.unhandledHarmfulEffects.get(), effect.getRegistryName());
    }

    public static boolean isAllowedEffect(@Nullable EffectInstance effectInstance) {
        return effectInstance != null && Helper.isAllowedEffect(effectInstance.func_188419_a());
    }

    public static boolean isAllowedEffect(@Nullable Effect effect) {
        return effect != null && effect.field_220305_b == EffectType.BENEFICIAL && !Helper.containRL((List)ConfigTombstone.general.unhandledBeneficialEffects.get(), effect.getRegistryName());
    }

    public static boolean containRL(List<String> listRL, @Nullable ResourceLocation rl) {
        return rl != null && listRL.stream().anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static void fillGradient(int left, int top, int right, int bottom, int color1, int color2, int zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor3F(color1);
        float[] argb2 = Helper.getRGBColor3F(color2);
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Helper.makeVertex(bufferbuilder, right, top, zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(bufferbuilder, left, top, zLevel, argb1);
        Helper.makeVertex(bufferbuilder, left, bottom, zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(bufferbuilder, right, bottom, zLevel, argb2);
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_181666_a(colorArray[0], colorArray[1], colorArray[2], 1.0f).func_181675_d();
    }

    public static EnchantmentType addEnchantmentType(String name, Predicate<Item> predic, EnchantmentType fallback) {
        EnchantmentType enchantType = EnchantmentType.create((String)name, predic);
        return enchantType == null ? fallback : enchantType;
    }

    public static Set<Enchantment> getTombstoneEnchantments(ItemStack stack) {
        ListNBT nbttaglist;
        boolean isEnchantedBook;
        boolean bl = isEnchantedBook = stack.func_77973_b() == Items.field_151134_bR;
        if (!isEnchantedBook && ((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentSoulbound.get()).booleanValue() && ((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentShadowStep.get()).booleanValue() && ((Boolean)SharedConfigTombstone.enchantments.enableEnchantmentMagicSiphon.get()).booleanValue()) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet list = Sets.newLinkedHashSet();
        ListNBT listNBT = nbttaglist = isEnchantedBook ? EnchantedBookItem.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        if (nbttaglist.size() > 0) {
            String soulboundId = ModEnchantments.soulbound.getRegistryName().toString();
            String shadowStepId = ModEnchantments.shadow_step.getRegistryName().toString();
            String magicSiphonId = ModEnchantments.magic_siphon.getRegistryName().toString();
            String plagueBringerId = ModEnchantments.plague_bringer.getRegistryName().toString();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
                if (!nbttagcompound.func_150297_b("id", 8)) continue;
                String id = nbttagcompound.func_74779_i("id");
                boolean isSoulBound = soulboundId.equals(id);
                boolean isShadowStep = shadowStepId.equals(id);
                boolean isMagicSiphon = magicSiphonId.equals(id);
                boolean isPlagueBringer = plagueBringerId.equals(id);
                if (!isSoulBound && !isShadowStep && !isMagicSiphon && !isPlagueBringer) continue;
                list.add(isSoulBound ? ModEnchantments.soulbound : (isShadowStep ? ModEnchantments.shadow_step : (isMagicSiphon ? ModEnchantments.magic_siphon : ModEnchantments.plague_bringer)));
            }
        }
        return list;
    }

    public static void damageItem(ItemStack stack, int amount, ServerPlayerEntity player, Hand hand) {
        stack.func_222118_a(amount, (LivingEntity)player, serverPlayer -> serverPlayer.func_213334_d(hand));
    }

    public static boolean isTameable(World world, String entityTypeString) {
        EntityType entityType;
        if (!entityTypeString.isEmpty() && (entityType = (EntityType)EntityType.func_220327_a((String)entityTypeString).orElse(null)) != null) {
            if (CompatibilityDruidCraft.instance.isTameable(entityType)) {
                return true;
            }
            Entity entity = entityType.func_200721_a(world);
            return entity instanceof TameableEntity || entity instanceof AbstractHorseEntity;
        }
        return false;
    }

    public static double getDistance(Vec3i vec1, Vec3i vec2) {
        return Math.sqrt(Helper.getDistanceSq(vec1, vec2));
    }

    public static double getDistanceSq(Vec3i vec1, Vec3i vec2) {
        return Helper.getDistanceSq(vec1, vec2.func_177958_n(), vec2.func_177956_o(), vec2.func_177952_p());
    }

    public static double getDistanceSq(Vec3i vec1, int x2, int y2, int z2) {
        return vec1.func_218140_a((double)x2, (double)y2, (double)z2, false);
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    public static Capability.IStorage<ISoulConsumer> getNullStorage() {
        return new Capability.IStorage<ISoulConsumer>(){

            @Nullable
            public INBT writeNBT(Capability<ISoulConsumer> capability, ISoulConsumer instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<ISoulConsumer> capability, ISoulConsumer instance, Direction side, INBT nbt) {
            }
        };
    }

    public static WorldFunctionInjector buildKnowledgeFunction() {
        return WorldFunctionInjector.builder().put(new ResourceLocation("tombstone", "knowledge"), (sender, params) -> {
            Entity entity = sender.func_197022_f();
            if (entity instanceof ServerPlayerEntity) {
                EntityHelper.addKnowledge((ServerPlayerEntity)entity, params.getInt("amount", 1));
            }
        }).build();
    }

    public static void loadContributors(MinecraftServer server) {
        Futures.addCallback(ContributorStore.read(CONTRIBUTORS_URL, server.field_110456_c), (FutureCallback)new FutureCallback<ContributorStore>(){

            public void onSuccess(@Nullable ContributorStore result) {
                CONTRIBUTORS = result;
                ModTombstone.LOGGER.info("The list of contributors has been loaded successfully");
            }

            public void onFailure(@Nonnull Throwable t) {
                ModTombstone.LOGGER.info("The list of contributors couldn't be loaded");
                t.printStackTrace();
            }
        }, (Executor)server);
    }

    public static void initCommands(CommandDispatcher<CommandSource> commandDispatcher) {
        new CommandTBRestoreInventory(commandDispatcher).registerCommand();
        new CommandTBShowLastGrave(commandDispatcher).registerCommand();
        new CommandTBTeleportGrave(commandDispatcher).registerCommand();
        new CommandTBKnownledge(commandDispatcher).registerCommand();
        new CommandTBAcceptTeleport(commandDispatcher).registerCommand();
        new CommandTBSiege(commandDispatcher).registerCommand();
        new CommandTBTeleportDiscovery(commandDispatcher).registerCommand();
        new CommandTBRecovery(commandDispatcher).registerCommand();
        new CommandTBTeleport(commandDispatcher).registerCommand();
        new CommandTBReviveFamiliar(commandDispatcher).registerCommand();
        new CommandTBTeleportHome(commandDispatcher).registerCommand();
        new CommandTBTeleportBiome(commandDispatcher).registerCommand();
        new CommandTBRequestTeleport(commandDispatcher).registerCommand();
        new CommandTBBind(commandDispatcher).registerCommand();
        new CommandTBTeleportDeath(commandDispatcher).registerCommand();
    }

    static {
        try {
            CONTRIBUTORS_URL = new URL("https://raw.githubusercontent.com/Corail31/trash/master/contributors.json");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

