/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.MoreObjects;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import ovh.corail.tombstone.helper.Helper;

public class Location {
    public int x;
    public int y;
    public int z;
    public int dim;
    static final BlockPos ORIGIN_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    public static final Location ORIGIN = new Location(ORIGIN_POS, Integer.MIN_VALUE);

    public Location(BlockPos pos, int dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public Location(BlockPos pos, IWorld world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
    }

    public Location(int x, int y, int z, IWorld world) {
        this(x, y, z, Helper.getDimensionId(world));
    }

    public Location(int x, int y, int z, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public Location(Entity entity) {
        this(entity.func_180425_c(), (IWorld)entity.field_70170_p);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(Location pos) {
        return pos.x == this.x && pos.y == this.y && pos.z == this.z && pos.dim == this.dim;
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public boolean isSameDimension(World world) {
        return this.dim == Helper.getDimensionId((IWorld)world);
    }

    public double getDistanceSq(Location location) {
        return this.getDistanceSq(location.getPos());
    }

    public double getDistanceSq(BlockPos pos) {
        double d0 = this.x - pos.func_177958_n();
        double d1 = this.y - pos.func_177956_o();
        double d2 = this.z - pos.func_177952_p();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isInRangeAndDimension(Location loc, int range) {
        return this.isInRange(loc, range) && this.dim == loc.dim;
    }

    public boolean isInRange(int x, int y, int z, int range) {
        return this.isInRange(new Location(x, y, z, this.dim), range);
    }

    public boolean isInRange(BlockPos position, int range) {
        return this.getDistanceSq(position) <= (double)(range * range);
    }

    public boolean isInRange(Location location, int range) {
        return this.getDistanceSq(location) <= (double)(range * range);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", this.dim).toString();
    }
}

