/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.storage.loot.EmptyLootEntry;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.registry.ModItems;

public class LootHelper {
    private static final Field fieldIsFrozen = ObfuscationReflectionHelper.findField(LootTable.class, (String)"isFrozen");

    private static void addEntry(LootPool.Builder builder, Item item, int weight, Consumer<CompoundNBT> consumer) {
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_216085_b(-2).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), consumer)))));
    }

    private static void addEnchantedEntry(LootPool.Builder builder, Item item, int weight) {
        LootHelper.addEntry(builder, item, weight, nbt -> nbt.func_74757_a("enchant", true));
    }

    private static void addAncientEntry(LootPool.Builder builder, Item item) {
        LootHelper.addEntry(builder, item, 3, nbt -> {
            nbt.func_74757_a("enchant", true);
            nbt.func_74757_a("ancient", true);
        });
    }

    public static void addLostEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:lost_treasure");
        builder.func_212840_b_(InOpenWaterCondition.builder());
        boolean valid = false;
        if (ModItems.tablet_of_recall.isEnabled()) {
            LootHelper.addAncientEntry(builder, ModItems.tablet_of_recall);
            valid = true;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addAncientEntry(builder, ModItems.tablet_of_home);
            valid = true;
        }
        int lostTabletChance = (Integer)SharedConfigTombstone.loot.chanceLootLostTablet.get();
        if (ModItems.lost_tablet.isEnabled() && lostTabletChance > 0) {
            builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.lost_tablet).func_216085_b(-2).func_216086_a(lostTabletChance));
            valid = true;
        }
        if (valid) {
            if (lostTabletChance < 1000) {
                builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(-2).func_216086_a(1000 - lostTabletChance));
            }
            try {
                fieldIsFrozen.set(table, false);
                table.addPool(builder.func_216044_b());
                fieldIsFrozen.set(table, true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addChestEntries(LootTableManager lootTableManager) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:chest_treasure");
        int weight = 0;
        for (ItemScrollBuff scroll : ModItems.scroll_buff) {
            if (!scroll.isEnabled()) continue;
            LootHelper.addEnchantedEntry(builder, scroll, 1);
            ++weight;
        }
        if (ModItems.scroll_of_knowledge.isEnabled()) {
            LootHelper.addEntry(builder, ModItems.scroll_of_knowledge, 1, nbt -> nbt.func_74768_a("stored_xp", 2000));
            ++weight;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_cupidity, 1);
            ++weight;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_home, 1);
            ++weight;
        }
        if (weight == 0) {
            return;
        }
        builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(100 - weight));
        LootPool chestTreasure = builder.func_216044_b();
        for (String targetTableString : (List)ConfigTombstone.loot.treasureLootTable.get()) {
            LootTable currentTable = lootTableManager.func_186521_a(new ResourceLocation(targetTableString));
            if (currentTable == LootTable.field_186464_a) continue;
            try {
                fieldIsFrozen.set(currentTable, false);
                currentTable.addPool(chestTreasure);
                fieldIsFrozen.set(currentTable, true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

