/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IImpregnable;
import ovh.corail.tombstone.item.ItemGeneric;

public class ItemBoneNeedle
extends ItemGeneric
implements IImpregnable {
    private static final int IMPREGNATED_MAX_TIME = TimeHelper.tickFromMinute(30);
    private static final ResourceLocation FILLED_PROPERTY = new ResourceLocation("filled");
    private static final String IMPREGNATED_TIME_NBT_LONG = "impregnated_time";

    public ItemBoneNeedle() {
        super("bone_needle", ItemBoneNeedle.getBuilder(true).func_200917_a(1));
        this.func_185043_a(FILLED_PROPERTY, (stack, world, entity) -> this.getEntityType(stack).isEmpty() ? 0.0f : 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            ITextComponent impregnated = this.getTooltipDisplay(stack);
            if (impregnated == null) {
                this.addItemUse(list);
            } else {
                list.add(impregnated);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
        int impregnatedTime = this.getImpregnatedTime(world, stack);
        if (impregnatedTime > 0) {
            this.addWarn(list, LangKey.MESSAGE_IMPREGNATE_DURATION, TimeHelper.getTimeString(impregnatedTime));
        }
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        ItemStack mainHandstack;
        if (EntityHelper.isValidPlayer(player) && hand == Hand.MAIN_HAND && (mainHandstack = player.func_184614_ca()).func_77973_b() == this && !EntityHelper.hasCooldown(player, this)) {
            EntityHelper.setCooldown(player, this, 10);
            if (!player.field_70170_p.field_72995_K) {
                boolean valid = this.impregnate(mainHandstack, target);
                if (valid) {
                    NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, TimeHelper.worldTicks(player.field_70170_p) + (long)IMPREGNATED_MAX_TIME);
                }
                player.func_145747_a(valid ? LangKey.MESSAGE_IMPREGNATE_NEEDLE_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, target.func_200200_C_()) : LangKey.MESSAGE_IMPREGNATE_NEEDLE_FAILED.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && !this.getEntityType(stack).isEmpty() && this.getImpregnatedTime(world, stack) == 1) {
            NBTStackHelper.removeKeyName(stack, IMPREGNATED_TIME_NBT_LONG);
            NBTStackHelper.removeKeyName(stack, "entity_type");
        }
    }

    private int getImpregnatedTime(@Nullable World world, ItemStack stack) {
        long impregnatedTime;
        if (world != null && stack.func_77973_b() == this && (impregnatedTime = NBTStackHelper.getLong(stack, IMPREGNATED_TIME_NBT_LONG, 0L)) > 0L) {
            int cd = (int)(impregnatedTime - TimeHelper.worldTicks(world));
            if (cd > IMPREGNATED_MAX_TIME) {
                NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, TimeHelper.worldTicks(world) + (long)IMPREGNATED_MAX_TIME);
                return IMPREGNATED_MAX_TIME;
            }
            return Math.max(cd, 0);
        }
        return 0;
    }
}

