/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.recipe.IDisableable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemGeneric
extends Item
implements IDisableable {
    protected final String name;
    private boolean hasEffect = false;
    private boolean isCraftingIngredient = false;
    private final Supplier<Boolean> supplierEnabled;

    public ItemGeneric(String name) {
        this(name, ItemGeneric.getBuilder(true), () -> true);
    }

    public ItemGeneric(String name, boolean hasTab) {
        this(name, ItemGeneric.getBuilder(hasTab), () -> true);
    }

    public ItemGeneric(String name, Item.Properties builder) {
        this(name, builder, () -> true);
    }

    public ItemGeneric(String name, Item.Properties builder, Supplier<Boolean> supplierEnabled) {
        super(builder);
        this.name = name;
        this.supplierEnabled = supplierEnabled;
        this.func_185043_a(new ResourceLocation("custom_model_data"), (stack, worldIn, entityIn) -> 0.0f);
    }

    public String getSimpleName() {
        return this.name;
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    public ItemGeneric withCraftingInfo() {
        this.isCraftingIngredient = true;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.supplierEnabled.get();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.isEnabled()) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasEffect || NBTStackHelper.getBoolean(stack, "enchant");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.isCraftingIngredient) {
            this.addInfo(list, LangKey.MESSAGE_CRAFTING_INGREDIENT, new Object[0]);
        }
        if (!this.isEnabled()) {
            this.addWarn(list, LangKey.MESSAGE_DISABLED, new Object[0]);
        }
    }

    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public void addItemDesc(List<ITextComponent> list) {
        this.addItemDesc(list, "", new Object[0]);
    }

    public void addItemDesc(List<ITextComponent> list, String id, Object ... format) {
        list.add(LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_DESC, this.func_77658_a() + ".desc" + id, format));
    }

    public void addItemUse(List<ITextComponent> list) {
        this.addItemUse(list, "", new Object[0]);
    }

    public void addItemUse(List<ITextComponent> list, String id, Object ... format) {
        list.add(LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_USE, this.func_77658_a() + ".use" + id, format));
    }

    public void addItemUse(List<ITextComponent> list, LangKey langKey, Object ... format) {
        list.add(langKey.getTranslationWithStyle(StyleType.TOOLTIP_USE, format));
    }

    public void addInfo(List<ITextComponent> list, LangKey langKey, Object ... format) {
        list.add(langKey.getTranslationWithStyle(StyleType.TOOLTIP_DESC, format));
    }

    public void addWarn(List<ITextComponent> list, LangKey langKey, Object ... format) {
        list.add(langKey.getTranslationWithStyle(StyleType.COLOR_OFF, format));
    }

    public void addInfoInBeta(List<ITextComponent> list) {
        list.add(LangKey.TOOLTIP_BETA.getTranslationWithStyle(StyleType.TOOLTIP_IN_BETA));
    }

    public void addInfoShowTooltip(List<ITextComponent> list) {
        this.addInfo(list, LangKey.TOOLTIP_MORE_INFO, new Object[0]);
    }

    public void addItemPosition(List<ITextComponent> list, Location location) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.func_180425_c();
            list.add(LangKey.MESSAGE_DISTANCE.getTranslation((int)Helper.getDistance((Vec3i)location.getPos(), (Vec3i)pos), location.x, location.y, location.z, location.dim));
        }
    }

    static Item.Properties getBuilder(boolean hasTab) {
        return new Item.Properties().func_200916_a((ItemGroup)(hasTab ? ModTabs.mainTab : null)).func_200917_a(64);
    }
}

