/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

public class ItemGraveKey
extends ItemGraveMagic {
    public ItemGraveKey() {
        super("grave_key", ItemGraveKey.getBuilder().func_200916_a(null), () -> SharedConfigTombstone.allowed_magic_items.allowGraveKey.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            String id = this.isEnchanted(stack) ? "2" : "1";
            this.addItemDesc(list, id, new Object[0]);
            Location location = this.getTombPos(stack);
            if (!location.isOrigin()) {
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() != this || location.isOrigin()) {
            return false;
        }
        NBTStackHelper.setLocation(stack, "tombPos", location);
        return true;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return Location.ORIGIN;
        }
        return NBTStackHelper.getLocation(stack, "tombPos");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && EntityHelper.isValidPlayer(entity) && stack.func_77973_b() == this) {
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && TimeHelper.atInterval(entity.field_70173_aa, TimeHelper.tickFromSecond(isSelected && entity.func_70092_e((double)location.getPos().func_177958_n(), (double)location.getPos().func_177956_o(), (double)location.getPos().func_177952_p()) < 100.0 ? 10 : 120))) {
                if (!location.isSameDimension(world)) {
                    return;
                }
                if (!World.func_189509_E((BlockPos)location.getPos())) {
                    if (!world.func_175667_e(location.getPos())) {
                        world.func_180495_p(location.getPos());
                    }
                    isBadKey = !(world.func_175625_s(location.getPos()) instanceof TileEntityGrave);
                } else {
                    isBadKey = true;
                }
            }
            if (isBadKey) {
                stack.func_190918_g(1);
                ((PlayerEntity)entity).field_71069_bz.func_75142_b();
            }
        }
    }

    public ItemStack findFirstKeyInInventory(PlayerEntity player) {
        return (ItemStack)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.grave_key).findFirst().orElse(ItemStack.field_190927_a)).orElse((Object)ItemStack.field_190927_a);
    }

    public boolean removeKeyForGraveInInventory(PlayerEntity player, Location graveLoc) {
        return (Boolean)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(inventPlayer -> {
            for (int i = 0; i < inventPlayer.getSlots(); ++i) {
                ItemStack stack = inventPlayer.getStackInSlot(i);
                if (stack.func_77973_b() != this || !this.getTombPos(stack).equals(graveLoc)) continue;
                inventPlayer.extractItem(i, 1, false);
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    public int countKeyInInventory(PlayerEntity player) {
        return (int)player.field_71071_by.field_70462_a.stream().filter(p -> p.func_77973_b() == this).count();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_CANT_ENCHANT_GRAVE_KEY.getTranslation();
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            player.func_145747_a(LangKey.MESSAGE_INVALID_LOCATION.getTranslation());
            return false;
        }
        if (!location.isSameDimension(world) && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.getTranslation());
            return false;
        }
        assert (player.func_184102_h() != null);
        ServerWorld targetWorld = player.func_184102_h().func_71218_a(DimensionType.func_186069_a((int)location.dim));
        if (Helper.isInvalidDimension(location.dim) || !Helper.isValidPos((World)targetWorld, location.getPos())) {
            player.func_145747_a(LangKey.MESSAGE_INVALID_LOCATION.getTranslation());
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addCallback(1, () -> {
            PlayerEntity newPlayer = (PlayerEntity)Helper.teleportToGrave(player, location);
            if (((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue()) {
                EntityHelper.capPotionDuration((LivingEntity)newPlayer, ModEffects.ghostly_shape, 200);
            }
            newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation());
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(PlayerEntity player, ItemStack key) {
        int chanceEnchantedKey;
        if (key.func_77973_b() == this && (chanceEnchantedKey = ((Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get()).intValue()) >= 0 && ((chanceEnchantedKey += EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20) >= 100 || chanceEnchantedKey > 0 && Helper.getRandom(1, 100) <= chanceEnchantedKey)) {
            NBTStackHelper.setBoolean(key, "enchant", true);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || state.func_177230_c().func_203417_a(ModTags.Blocks.player_graves);
    }
}

