/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfAssistance
extends ItemTablet {
    public ItemTabletOfAssistance() {
        super("tablet_of_assistance", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfAssistance.get());
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = LangKey.makeTranslation(this.func_77667_c(stack), new Object[0]);
        return this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getTranslation(name) : name;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (list.size() > 0) {
            list.set(0, list.get(0).func_150255_a(StyleType.MESSAGE_SPECIAL));
        }
        if (Helper.canShowTooltip(world, stack)) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                String engraved_name = this.getEngravedName(stack);
                if (engraved_name.isEmpty()) {
                    this.addItemDesc(list);
                    this.addItemUse(list, "2", StyleType.TOOLTIP_ITEM.func_150218_j() + "[" + I18n.func_135052_a((String)ModItems.grave_dust.func_77667_c(stack), (Object[])new Object[0]).toLowerCase() + "]");
                } else {
                    this.addInfo(list, LangKey.MESSAGE_ENGRAVED, '\"' + engraved_name + '\"');
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        return true;
    }

    public boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (this.isEnchanted(stack)) {
            NBTStackHelper.setString(stack, "engraved_name", engraved_name);
            return true;
        }
        return false;
    }

    public String getEngravedName(ItemStack stack) {
        return this.isEnchanted(stack) ? NBTStackHelper.getString(stack, "engraved_name") : "";
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        String engraved_name = NBTStackHelper.getString(stack, "engraved_name");
        if (engraved_name.equals(player.func_200200_C_().func_150261_e())) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_SAME_PLAYER.getTranslation());
            return false;
        }
        assert (world.func_73046_m() != null);
        if (Stream.of(world.func_73046_m().func_71213_z()).noneMatch(p -> p.equals(engraved_name))) {
            if (world.func_73046_m().func_152358_ax().field_152661_c.keySet().contains(engraved_name)) {
                player.func_145747_a(LangKey.MESSAGE_PLAYER_OFFLINE.getTranslation());
            } else {
                player.func_145747_a(LangKey.MESSAGE_PLAYER_INVALID.getTranslation());
            }
            return false;
        }
        ServerPlayerEntity receiver = world.func_73046_m().func_184103_al().func_152612_a(engraved_name);
        if (receiver == null) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_FAILED.getTranslation());
            return false;
        }
        if (receiver.field_71093_bK != player.field_71093_bK && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.getTranslation());
            return false;
        }
        ITextComponent hereClick = LangKey.createComponentCommand((PlayerEntity)receiver, "/tbacceptteleport " + player.func_110124_au(), LangKey.MESSAGE_HERE, new Object[0]);
        receiver.func_145747_a(LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.getTranslation(hereClick, player.func_200200_C_()).func_150255_a(StyleType.MESSAGE_SPECIAL));
        CommandTBAcceptTeleport.addTicket((PlayerEntity)receiver, (PlayerEntity)player, 120);
        player.func_145747_a(LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.getTranslation(receiver.func_200200_C_()));
        ModTriggers.USE_ASSISTANCE.trigger(player);
        return true;
    }

    @Override
    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || state.func_177230_c().func_203417_a(BlockTags.field_200572_k);
    }
}

