/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfCupidity.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
            this.addInfoInBeta(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return false;
        }
        this.setUseCount(stack, this.getUseMax());
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        Location spawnPos;
        TileEntity tile = (TileEntity)Helper.getRandomInList(((ServerWorld)world).field_147482_g.stream().filter(aTile -> aTile instanceof MobSpawnerTileEntity || aTile instanceof ChestTileEntity && ((LockableLootTileEntity)aTile).field_184284_m != null).collect(Collectors.toList()));
        if (tile != null && Helper.isValidPos(world, tile.func_174877_v()) && !(spawnPos = new SpawnHelper((ServerWorld)world, tile.func_174877_v()).findSpawnPlace(false)).isOrigin()) {
            CallbackHandler.addCallback(1, () -> {
                ServerPlayerEntity newPlayer = Helper.teleportEntity(player, spawnPos);
                newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation());
                EntityHelper.addAlignment(newPlayer, -1, 0.5f);
                Helper.addRandomEffect((PlayerEntity)newPlayer, 1200, true, true);
                ModTriggers.USE_CUPIDITY.trigger(newPlayer);
            });
            return true;
        }
        player.func_145747_a(LangKey.MESSAGE_TABLET_SEARCH_FAILED.getTranslation());
        return true;
    }

    @Override
    public int getCastingCooldown() {
        return 18000;
    }
}

