/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.perk.PerkRegistry;

public class SyncCapClientMessage {
    private SyncType syncType;
    private long knowledge;
    private HashMap<Perk, Integer> perks;
    private Perk perk;
    private int level;
    private long nextPray;
    private int alignment;

    public SyncCapClientMessage(SyncType syncType, Object ... params) {
        this.syncType = syncType;
        if (syncType == SyncType.ALL) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
            this.nextPray = params.length > 1 ? (Long)params[1] : -1L;
            this.alignment = params.length > 2 ? (Integer)params[2] : 0;
            this.perks = params.length > 3 ? (HashMap)params[3] : new HashMap();
        } else if (syncType == SyncType.KNOWLEDGE) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
        } else if (syncType == SyncType.NEXT_PRAY) {
            this.nextPray = params.length > 0 ? (Long)params[0] : -1L;
        } else if (syncType == SyncType.ALIGNMENT) {
            this.alignment = params.length > 0 ? (Integer)params[0] : 0;
        } else if (syncType == SyncType.PERKS) {
            this.perks = params.length > 0 ? (HashMap)params[0] : new HashMap();
        } else if (syncType == SyncType.SET_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
            this.level = params.length > 1 ? (Integer)params[1] : 1;
        } else if (syncType == SyncType.REMOVE_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
        }
    }

    static SyncCapClientMessage fromBytes(PacketBuffer buf) {
        SyncType syncType = SyncType.values()[buf.readShort()];
        switch (syncType) {
            case KNOWLEDGE: 
            case NEXT_PRAY: {
                return new SyncCapClientMessage(syncType, buf.readLong());
            }
            case ALIGNMENT: {
                return new SyncCapClientMessage(syncType, buf.readInt());
            }
            case ALL: {
                CompoundNBT tag;
                long knowledge = buf.readLong();
                long nextPray = buf.readLong();
                int alignment = buf.readInt();
                try {
                    tag = buf.func_150793_b();
                }
                catch (Exception e) {
                    tag = null;
                }
                return new SyncCapClientMessage(syncType, knowledge, nextPray, alignment, SyncCapClientMessage.readPerks(tag));
            }
            case PERKS: {
                CompoundNBT tag;
                try {
                    tag = buf.func_150793_b();
                }
                catch (Exception e) {
                    tag = null;
                }
                return new SyncCapClientMessage(syncType, SyncCapClientMessage.readPerks(tag));
            }
            case SET_PERK: {
                return new SyncCapClientMessage(syncType, PerkRegistry.perkRegistry.getValue(buf.readInt()), buf.readInt());
            }
            case REMOVE_PERK: {
                return new SyncCapClientMessage(syncType, PerkRegistry.perkRegistry.getValue(buf.readInt()));
            }
        }
        return new SyncCapClientMessage(syncType, buf.readLong(), buf.readLong());
    }

    private static HashMap<Perk, Integer> readPerks(CompoundNBT tag) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        if (tag != null && tag.func_150297_b("perks", 9)) {
            ListNBT tagPerks = tag.func_150295_c("perks", 10);
            for (int i = 0; i < tagPerks.size(); ++i) {
                Perk perk;
                CompoundNBT tagPerk = tagPerks.func_150305_b(i);
                if (!tagPerk.func_150297_b("id", 3) || !tagPerk.func_150297_b("level", 3) || (perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"))) == null) continue;
                perks.put(perk, tagPerk.func_74762_e("level"));
            }
        }
        return perks;
    }

    static void toBytes(SyncCapClientMessage msg, PacketBuffer buf) {
        boolean isSyncAll;
        buf.writeShort(msg.syncType.ordinal());
        boolean bl = isSyncAll = msg.syncType == SyncType.ALL;
        if (isSyncAll || msg.syncType == SyncType.KNOWLEDGE) {
            buf.writeLong(msg.knowledge);
        }
        if (isSyncAll || msg.syncType == SyncType.NEXT_PRAY) {
            buf.writeLong(msg.nextPray);
        }
        if (isSyncAll || msg.syncType == SyncType.ALIGNMENT) {
            buf.writeInt(msg.alignment);
        }
        if (isSyncAll || msg.syncType == SyncType.PERKS) {
            CompoundNBT tag = new CompoundNBT();
            ListNBT tagPerks = new ListNBT();
            for (Map.Entry<Perk, Integer> entry : msg.perks.entrySet()) {
                CompoundNBT tagPerk = new CompoundNBT();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)entry.getKey()));
                tagPerk.func_74768_a("level", entry.getValue().intValue());
                tagPerks.add((Object)tagPerk);
            }
            tag.func_218657_a("perks", (INBT)tagPerks);
            buf.func_150786_a(tag);
        }
        if (msg.syncType == SyncType.SET_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
            buf.writeInt(msg.level);
        }
        if (msg.syncType == SyncType.REMOVE_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
        }
    }

    public static class Handler {
        static void handle(SyncCapClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                            switch (message.syncType) {
                                case ALL: {
                                    cap.setKnowledge(message.knowledge);
                                    cap.setNextPray(message.nextPray);
                                    cap.setAlignment(message.alignment);
                                    cap.setPerks(message.perks);
                                    break;
                                }
                                case KNOWLEDGE: {
                                    cap.setKnowledge(message.knowledge);
                                    break;
                                }
                                case PERKS: {
                                    cap.setPerks(message.perks);
                                    break;
                                }
                                case SET_PERK: {
                                    cap.setPerk(message.perk, message.level);
                                    break;
                                }
                                case REMOVE_PERK: {
                                    cap.removePerk(message.perk);
                                    break;
                                }
                                case NEXT_PRAY: {
                                    cap.setNextPray(message.nextPray);
                                    break;
                                }
                                case ALIGNMENT: {
                                    cap.setAlignment(message.alignment);
                                    break;
                                }
                            }
                        });
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum SyncType {
        ALL,
        KNOWLEDGE,
        PERKS,
        SET_PERK,
        REMOVE_PERK,
        NEXT_PRAY,
        ALIGNMENT;

    }
}

