/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class TileEntityWritableGrave
extends TileEntity
implements ITickableTileEntity {
    protected String ownerName = "";
    protected long deathDate;
    public int countTicks = 0;

    public TileEntityWritableGrave(TileEntityType tileType) {
        super(tileType);
    }

    public abstract boolean canShowFog();

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            ++this.countTicks;
            if (this.field_145850_b.field_72995_K) {
                if (this.canShowFog()) {
                    ModTombstone.PROXY.produceGraveSmoke(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                }
            } else if (TimeHelper.atInterval(this.countTicks, 600) && Helper.isAprilFoolsDay() && Helper.random.nextFloat() < 0.3f) {
                Vec3d centerVec = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 1.0, 0.5);
                PlayerEntity closestPlayer = this.field_145850_b.func_217366_a(centerVec.field_72450_a, centerVec.field_72448_b, centerVec.field_72449_c, 20.0, false);
                if (closestPlayer != null) {
                    SnowballEntity snowballentity = new SnowballEntity(this.field_145850_b, centerVec.field_72450_a, centerVec.field_72448_b, centerVec.field_72449_c);
                    if (this.canSeeEntity(centerVec, (Entity)closestPlayer)) {
                        snowballentity.func_213884_b(new ItemStack((IItemProvider)Items.field_151103_aS));
                        snowballentity.getPersistentData().func_74757_a("april_fool_slowness", true);
                        Vec3d vec = closestPlayer.func_213303_ch().func_72441_c(0.0, (double)closestPlayer.func_70047_e(), 0.0).func_178788_d(snowballentity.func_213303_ch());
                        snowballentity.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.5f, 1.0f);
                        this.field_145850_b.func_217376_c((Entity)snowballentity);
                    }
                }
            }
        }
    }

    private boolean canSeeEntity(Vec3d vec3d, Entity entity) {
        Vec3d vec3d1 = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        assert (this.field_145850_b != null);
        return this.field_145850_b.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public void setOwner(Entity owner, long deathDate) {
        this.setOwner(owner.func_200200_C_().func_150261_e(), deathDate);
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return this.ownerName.length() > 0;
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
        this.countTicks = 0;
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return this.writeShared(compound);
    }

    protected CompoundNBT writeShared(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.countTicks);
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("ownerName")) {
            this.ownerName = compound.func_74779_i("ownerName");
        }
        if (compound.func_74764_b("deathDate")) {
            this.deathDate = compound.func_74763_f("deathDate");
        }
        if (compound.func_74764_b("countTicks")) {
            this.countTicks = compound.func_74762_e("countTicks");
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.writeShared(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
    }

    public void func_222814_r() {
    }
}

