/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.helper.Helper;

public enum SupportStructures {
    VILLAGE("village", 68),
    DESERT_TEMPLE("desert_pyramid", 68),
    IGLOO_TEMPLE("igloo", 68),
    JUNGLE_TEMPLE("jungle_pyramid", 68),
    MANSION("mansion", 68),
    MONUMENT("monument", 68),
    STRONGHOLD("stronghold", 35),
    END_CITY("endcity", 68),
    MINESHAFT("mineshaft", 37),
    FORTRESS("fortress", 35),
    SWAMP_HUT("swamp_hut", 68),
    OCEAN_RUIN("ocean_ruin", 68),
    BURIED_TREASURE("buried_treasure", 68),
    SHIPWRECK("shipwreck", 68),
    PILLAGER_OUTPOST("pillager_outpost", 68);

    private final String structureName;
    private final int y;
    private static final Map<String, String> STRUCTURE_NAMES;

    private SupportStructures(String structureName, int y) {
        this.structureName = structureName;
        this.y = y;
    }

    public String getId() {
        return "minecraft:" + this.structureName;
    }

    public boolean is(String structureId) {
        Pair<String, String> rl = Helper.parseRLString(structureId);
        return "minecraft".equals(rl.getLeft()) && this.structureName.equals(rl.getRight());
    }

    public boolean is(ResourceLocation structureId) {
        return this.is(structureId.func_110624_b(), structureId.func_110623_a());
    }

    public boolean is(String domain, String path) {
        return "minecraft".equals(domain) && this.structureName.equals(path);
    }

    public int getY() {
        return this.y;
    }

    public static String getStructureNameForSearch(String structureId) {
        return structureId.startsWith("minecraft:") ? structureId.toLowerCase(Locale.ROOT).substring(10) : structureId;
    }

    @Nullable
    private static SupportStructures getVanillaStructure(String domain, String path) {
        return domain.equals("minecraft") ? (SupportStructures)Stream.of(SupportStructures.values()).filter(p -> p.structureName.equals(path)).findFirst().orElse(null) : null;
    }

    public static int getY(ResourceLocation structureRL) {
        return SupportStructures.getY(structureRL.func_110624_b(), structureRL.func_110623_a());
    }

    public static int getY(String structureRLString) {
        Pair<String, String> rl = Helper.parseRLString(structureRLString);
        return SupportStructures.getY((String)rl.getLeft(), (String)rl.getRight());
    }

    public static int getY(String domain, String path) {
        SupportStructures struct = SupportStructures.getVanillaStructure(domain, path);
        return struct != null ? struct.getY() : (domain.equals("quark") ? 37 : 68);
    }

    @Nullable
    public static String getRandomVanillaStructure(Predicate<ResourceLocation> predic) {
        return SupportStructures.getRandomStructure(p -> p.func_110624_b().equals("minecraft") && predic.test((ResourceLocation)p));
    }

    @Nullable
    public static String getRandomStructure(Predicate<ResourceLocation> predic) {
        List list = GameData.getStructureFeatures().func_148742_b().stream().filter(predic).collect(Collectors.toList());
        return list.isEmpty() ? null : ((ResourceLocation)list.get(Helper.random.nextInt(list.size()))).toString();
    }

    public static boolean hasStructureInWorld(@Nullable ServerWorld world, Structure<?> structure) {
        return world != null && world.func_72912_H().func_76089_r() && world.func_72863_F().func_201711_g().func_202090_b().func_205004_a(structure);
    }

    public static Structure<?> getStructure(String name) {
        return (Structure)Feature.field_202300_at.get((Object)SupportStructures.getStructureNameForSearch(name));
    }

    public static List<DimensionType> getDimensionTypesForStructure(MinecraftServer server, Structure<?> structure) {
        return DimensionManager.getRegistry().func_201756_e().filter(dimensionType -> SupportStructures.hasStructureInWorld(DimensionManager.getWorld((MinecraftServer)server, (DimensionType)dimensionType, (boolean)true, (boolean)true), structure)).collect(Collectors.toList());
    }

    public static String getStructureName(String structureId) {
        return STRUCTURE_NAMES.computeIfAbsent(structureId, k -> SupportStructures.getStructure(k).func_143025_a());
    }

    static {
        STRUCTURE_NAMES = new HashMap<String, String>();
    }
}

