/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class BrazierBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape INNER_SHAPE = Block.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BrazierBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)LIT, (Comparable)Boolean.TRUE)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (!entity.func_70045_F() && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entity)) && (double)entity.func_180425_c().func_177958_n() >= (double)pos.func_177958_n() + 0.1 && (double)entity.func_180425_c().func_177952_p() >= (double)pos.func_177952_p() + 0.1 && (double)entity.func_180425_c().func_177958_n() <= (double)pos.func_177958_n() + 0.9 && (double)entity.func_180425_c().func_177952_p() <= (double)pos.func_177952_p() + 0.9) {
            entity.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_196262_a(state, worldIn, pos, entity);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos;
        World iworld = context.func_195991_k();
        boolean flag = iworld.func_204610_c(blockpos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197878_a((VoxelShape)SHAPE, (VoxelShape)INNER_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            boolean flag = (Boolean)state.func_177229_b((IProperty)LIT);
            if (flag) {
                TileEntity tileentity;
                if (!world.func_201670_d()) {
                    world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if ((tileentity = world.func_175625_s(pos)) instanceof CampfireTileEntity) {
                    ((CampfireTileEntity)tileentity).func_213986_d();
                }
            }
            world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.TRUE)).func_206870_a((IProperty)LIT, (Comparable)Boolean.FALSE), 3);
            world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReader)world));
            return true;
        }
        return false;
    }

    @Nullable
    private Entity func_226913_a_(Entity entity) {
        if (entity instanceof AbstractFireballEntity) {
            return ((AbstractFireballEntity)entity).field_70235_a;
        }
        return entity instanceof AbstractArrowEntity ? ((AbstractArrowEntity)entity).func_212360_k() : null;
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        if (!world.func_201670_d()) {
            boolean flag;
            boolean bl = flag = projectile instanceof AbstractFireballEntity || projectile instanceof AbstractArrowEntity && projectile.func_70027_ad();
            if (flag) {
                boolean flag1;
                Entity entity = this.func_226913_a_(projectile);
                boolean bl2 = flag1 = entity == null || entity instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity);
                if (flag1 && !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                    BlockPos blockpos = hit.func_216350_a();
                    world.func_180501_a(blockpos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
                }
            }
        }
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LIT, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

