/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world;

import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.init.ModStructures;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.DungeonRoomConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGen {
    public static List<Structure<NoFeatureConfig>> structures = new ArrayList<Structure<NoFeatureConfig>>();

    public static void setupWorldGen() {
        DeferredWorkQueue.runLater(() -> {
            Iterator biomes = ForgeRegistries.BIOMES.iterator();
            biomes.forEachRemaining(biome -> {
                if (biome.func_201856_r() != Biome.Category.RIVER && biome.func_201856_r() != Biome.Category.OCEAN) {
                    if ((biome.func_201856_r() == Biome.Category.PLAINS || biome.func_201856_r() == Biome.Category.FOREST || biome.func_201856_r() == Biome.Category.EXTREME_HILLS || biome.func_201856_r() == Biome.Category.TAIGA) && biome.func_150561_m() == Biome.TempCategory.MEDIUM && biome.func_201851_b() == Biome.RainType.RAIN) {
                        if (((Boolean)StructureGenConfig.GENERATE_CASTLES.get()).booleanValue()) {
                            WorldGen.addSurfaceStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.CASTLE.get()));
                        }
                        if (((Boolean)StructureGenConfig.GENERATE_CASTLE_RUINS.get()).booleanValue()) {
                            WorldGen.addSurfaceStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.CASTLE_RUIN.get()));
                        }
                        if (((Boolean)StructureGenConfig.GENERATE_FORGES.get()).booleanValue()) {
                            WorldGen.addSurfaceStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.FORGE.get()));
                        }
                        if (((Boolean)StructureGenConfig.GENERATE_PLAYER_HOUSES.get()).booleanValue()) {
                            WorldGen.addSurfaceStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.PLAYER_HOUSE.get()));
                        }
                        if (((Boolean)StructureGenConfig.GENERATE_TOWER_RUINS.get()).booleanValue()) {
                            WorldGen.addSurfaceStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.TOWER_RUIN.get()));
                        }
                    }
                    if (biome.func_201856_r() == Biome.Category.DESERT && biome.func_201851_b() == Biome.RainType.NONE && ((Boolean)StructureGenConfig.GENERATE_DESERT_HOUSES.get()).booleanValue()) {
                        WorldGen.addSurfaceStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.DESERT_HOUSE.get()));
                    }
                    if (biome.func_201856_r() != Biome.Category.NETHER && biome.func_201856_r() != Biome.Category.THEEND && ((Boolean)StructureGenConfig.GENERATE_SMALL_DUNGEONS.get()).booleanValue()) {
                        WorldGen.addUndergroundStructure(biome, (Structure<NoFeatureConfig>)((Structure)ModStructures.SMALL_DUNGEON.get()));
                    }
                }
            });
        });
    }

    private static void addSurfaceStructure(Biome biome, Structure<NoFeatureConfig> structure) {
        biome.func_201865_a(structure, (IFeatureConfig)IFeatureConfig.field_202429_e);
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(structure, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
        structures.add(structure);
    }

    private static void addUndergroundStructure(Biome biome, Structure<NoFeatureConfig> structure) {
        biome.func_201865_a(structure, (IFeatureConfig)IFeatureConfig.field_202429_e);
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(structure, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215007_F, (IPlacementConfig)new DungeonRoomConfig(8)));
        structures.add(structure);
    }
}

