/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world.structures;

import com.mojang.datafixers.Dynamic;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class AbstractValhelsiaStructure
extends ScatteredStructure<NoFeatureConfig> {
    public static final int DEFAULT_CHUNK_RADIUS = 2;
    private final String name;

    public AbstractValhelsiaStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, String name) {
        super(configFactoryIn);
        this.name = name;
    }

    protected abstract double getSpawnChance();

    public int func_202367_b() {
        return 2;
    }

    protected int func_204030_a(ChunkGenerator<?> generator) {
        return this.getFeatureDistance(generator);
    }

    protected abstract int getFeatureDistance(ChunkGenerator<?> var1);

    protected int func_211745_b(ChunkGenerator<?> generator) {
        return this.getFeatureSeparation(generator);
    }

    protected abstract int getFeatureSeparation(ChunkGenerator<?> var1);

    @Nonnull
    public String func_143025_a() {
        return new ResourceLocation("valhelsia_structures", this.name).toString();
    }

    @Nonnull
    protected ChunkPos func_211744_a(@Nonnull ChunkGenerator<?> generator, @Nonnull Random random, int chunkX, int chunkZ, int offsetX, int offsetZ) {
        int featureDistance = this.getFeatureDistance(generator);
        int featureSeparation = this.getFeatureSeparation(generator);
        int xTemp = chunkX + featureDistance * offsetX;
        int zTemp = chunkZ + featureDistance * offsetZ;
        int validChunkX = (xTemp < 0 ? xTemp - featureDistance + 1 : xTemp) / featureDistance;
        int validChunkZ = (zTemp < 0 ? zTemp - featureDistance + 1 : zTemp) / featureDistance;
        ((SharedSeedRandom)random).func_202427_a(generator.func_202089_c(), validChunkX, validChunkZ, this.func_202382_c());
        validChunkX *= featureDistance;
        validChunkZ *= featureDistance;
        return new ChunkPos(validChunkX += random.nextInt(featureDistance - featureSeparation) + random.nextInt(featureDistance - featureSeparation) / 2, validChunkZ += random.nextInt(featureDistance - featureSeparation) + random.nextInt(featureDistance - featureSeparation) / 2);
    }

    public boolean func_202372_a(@Nonnull ChunkGenerator<?> generator, @Nonnull Random random, int chunkX, int chunkZ) {
        IWorld world = (IWorld)ObfuscationReflectionHelper.getPrivateValue(ChunkGenerator.class, generator, (String)"field_222540_a");
        if (world == null || world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        ChunkPos chunkPos = this.func_211744_a(generator, random, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkPos.field_77276_a && chunkZ == chunkPos.field_77275_b && this.isSurfaceFlat(generator, chunkX, chunkZ)) {
            if (!generator.func_202090_b().func_201538_a((chunkX << 4) + 9, (chunkZ << 4) + 9, this.func_202367_b() * 16).stream().allMatch(biome -> generator.func_202094_a(biome, (Structure)this))) {
                return false;
            }
            for (int k = chunkX - 5; k <= chunkX + 5; ++k) {
                for (int l = chunkZ - 5; l <= chunkZ + 5; ++l) {
                    BlockPos position = new BlockPos((k << 4) + 9, 0, (l << 4) + 9);
                    if (!Feature.field_214550_p.func_202372_a(generator, random, chunkX, chunkZ)) continue;
                    return false;
                }
            }
            int i = chunkX >> 4;
            int j = chunkZ >> 4;
            random.setSeed((long)(i ^ j << 4) ^ generator.func_202089_c());
            random.nextInt();
            return random.nextDouble() < this.getSpawnChance();
        }
        return false;
    }

    protected boolean isSurfaceFlat(@Nonnull ChunkGenerator<?> generator, int chunkX, int chunkZ) {
        int offset = this.func_202367_b() * 16;
        int xStart = chunkX << 4;
        int zStart = chunkZ << 4;
        int i1 = generator.func_222531_c(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222531_c(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222531_c(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222531_c(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
        return Math.abs(maxHeight - minHeight) <= (Integer)StructureGenConfig.FLATNESS_DELTA.get();
    }
}

