/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world.structures;

import com.mojang.datafixers.Dynamic;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.world.structures.CastlePieces;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CastleStructure
extends AbstractValhelsiaStructure {
    private static final int CHUNK_RADIUS = 3;
    public static final String SHORT_NAME = "castle";

    public CastleStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory, SHORT_NAME);
    }

    @Override
    public int func_202367_b() {
        return 3;
    }

    @Override
    protected int getFeatureDistance(ChunkGenerator<?> generator) {
        return (Integer)StructureGenConfig.CASTLE_DISTANCE.get();
    }

    @Override
    protected int getFeatureSeparation(ChunkGenerator<?> generator) {
        return (Integer)StructureGenConfig.CASTLE_SEPARATION.get();
    }

    @Override
    protected double getSpawnChance() {
        return (Double)StructureGenConfig.CASTLE_SPAWN_CHANCE.get();
    }

    protected int func_202382_c() {
        return 16987356;
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkY, Biome biome, MutableBoundingBox bounds, int reference, long seed) {
            super(structure, chunkX, chunkY, biome, bounds, reference, seed);
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager templateManager, int chunkX, int chunkZ, @Nonnull Biome biome) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            BlockPos position = StructureUtils.getSurfaceStructurePosition(generator, 3, rotation, chunkX, chunkZ);
            CastlePieces.generate(generator, templateManager, position, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
        }
    }
}

