/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world.structures;

import com.mojang.datafixers.Dynamic;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.world.structures.SmallDungeonPieces;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallDungeonStructure
extends AbstractValhelsiaStructure {
    public static final String SHORT_NAME = "small_dungeon";
    public static final String FULL_NAME = "valhelsia_structures:small_dungeon";
    private static final int CHUNK_RADIUS = 3;
    private static final int SEED_MODIFIER = 14357670;

    public SmallDungeonStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory, SHORT_NAME);
    }

    protected int func_202382_c() {
        return 14357670;
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    @Nonnull
    public String func_143025_a() {
        return FULL_NAME;
    }

    @Override
    public int func_202367_b() {
        return 3;
    }

    @Override
    protected int getFeatureDistance(ChunkGenerator<?> generator) {
        return (Integer)StructureGenConfig.SMALL_DUNGEON_DISTANCE.get();
    }

    @Override
    protected int getFeatureSeparation(ChunkGenerator<?> generator) {
        return (Integer)StructureGenConfig.SMALL_DUNGEON_SEPARATION.get();
    }

    @Override
    protected double getSpawnChance() {
        return (Double)StructureGenConfig.SMALL_DUNGEON_SPAWN_CHANCE.get();
    }

    @Override
    public boolean func_202372_a(@Nonnull ChunkGenerator<?> generator, @Nonnull Random random, int chunkX, int chunkZ) {
        ChunkPos chunkPos = this.func_211744_a(generator, random, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkPos.field_77276_a && chunkZ == chunkPos.field_77275_b) {
            return generator.func_202090_b().func_201538_a((chunkX << 4) + 9, (chunkZ << 4) + 9, this.func_202367_b() * 16).stream().allMatch(biome -> generator.func_202094_a(biome, (Structure)this));
        }
        return false;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkY, Biome biome, MutableBoundingBox bounds, int reference, long seed) {
            super(structure, chunkX, chunkY, biome, bounds, reference, seed);
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager templateManager, int chunkX, int chunkZ, @Nonnull Biome biome) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            SmallDungeonPieces.generate(generator, templateManager, blockpos, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
            this.func_214628_a(generator.func_222530_f(), (Random)this.field_214631_d, 10);
        }
    }
}

