/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import com.google.common.collect.Lists;
import com.stal111.valhelsia_structures.utils.SpecialWeightedSpawnerEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SpecialAbstractSpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private int spawnDelay = 20;
    private final List<SpecialWeightedSpawnerEntity> potentialSpawns = Lists.newArrayList();
    private SpecialWeightedSpawnerEntity spawnData = new SpecialWeightedSpawnerEntity();
    private double mobRotation;
    private double prevMobRotation;
    private int minSpawnDelay = 80;
    private int maxSpawnDelay = 100;
    private int spawnCount = 5;
    private Entity cachedEntity;
    private int maxNearbyEntities = 7;
    private int activatingRangeFromPlayer = 8;
    private int spawnRange = 4;
    private int waveCount = 0;

    @Nullable
    private ResourceLocation getEntityId() {
        String s = this.spawnData.getNbt().func_74779_i("id");
        try {
            return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
        }
        catch (ResourceLocationException var4) {
            BlockPos blockpos = this.getSpawnerPosition();
            LOGGER.warn("Invalid entity id '{}' at spawner {}:[{},{},{}]", (Object)s, (Object)this.getWorld().field_73011_w.func_186058_p(), (Object)blockpos.func_177958_n(), (Object)blockpos.func_177956_o(), (Object)blockpos.func_177952_p());
            return null;
        }
    }

    public void setEntityType(EntityType<?> type) {
        this.spawnData.getNbt().func_74778_a("id", Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(type)).toString());
    }

    private boolean isActivated() {
        BlockPos blockpos = this.getSpawnerPosition();
        for (PlayerEntity playerentity : this.getWorld().func_217369_A()) {
            if (!EntityPredicates.field_180132_d.test(playerentity) || !EntityPredicates.field_212545_b.test(playerentity)) continue;
            double d0 = playerentity.func_70092_e((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
            if (!((double)this.activatingRangeFromPlayer < 0.0) && !(d0 < (double)(this.activatingRangeFromPlayer * this.activatingRangeFromPlayer)) || !(playerentity.func_226278_cu_() >= (double)blockpos.func_177956_o())) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        if (!this.isActivated()) {
            this.prevMobRotation = this.mobRotation;
        } else {
            World world = this.getWorld();
            BlockPos blockpos = this.getSpawnerPosition();
            if (world.field_72995_K) {
                double d3 = (float)blockpos.func_177958_n() + world.field_73012_v.nextFloat();
                double d4 = (float)blockpos.func_177956_o() + world.field_73012_v.nextFloat();
                double d5 = (float)blockpos.func_177952_p() + world.field_73012_v.nextFloat();
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d4, d5, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.prevMobRotation = this.mobRotation;
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    double d2;
                    CompoundNBT compoundnbt = this.spawnData.getNbt();
                    Optional optional = EntityType.func_220347_a((CompoundNBT)compoundnbt);
                    if (!optional.isPresent()) {
                        this.resetTimer();
                        return;
                    }
                    ListNBT listnbt = compoundnbt.func_150295_c("Pos", 6);
                    int j = listnbt.size();
                    double d0 = j >= 1 ? listnbt.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                    double d1 = j >= 2 ? listnbt.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? listnbt.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!world.func_226664_a_(((EntityType)optional.get()).func_220328_a(d0, d1, d2))) continue;
                    Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, p_221408_6_ -> {
                        p_221408_6_.func_70012_b(d0, d1, d2, p_221408_6_.field_70177_z, p_221408_6_.field_70125_A);
                        return p_221408_6_;
                    });
                    if (entity == null) {
                        this.resetTimer();
                        return;
                    }
                    int k = world.func_217357_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.resetTimer();
                        return;
                    }
                    entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof MobEntity && this.spawnData.getNbt().func_186856_d() == 1 && this.spawnData.getNbt().func_150297_b("id", 8)) {
                        ((MobEntity)entity).func_213386_a((IWorld)world, world.func_175649_E(new BlockPos(entity)), SpawnReason.SPAWNER, null, null);
                    }
                    this.func_221409_a(entity);
                    world.func_217379_c(2004, blockpos, 0);
                    if (entity instanceof MobEntity) {
                        ((MobEntity)entity).func_70656_aK();
                    }
                    flag = true;
                    Random random = new Random();
                    if (!(random.nextDouble() <= 0.15 && this.waveCount >= 1) && this.waveCount < 3) continue;
                    world.func_217378_a(null, 2001, this.getSpawnerPosition(), Block.func_196246_j((BlockState)world.func_180495_p(this.getSpawnerPosition())));
                    world.func_175656_a(this.getSpawnerPosition(), Blocks.field_150350_a.func_176223_P());
                }
                if (flag) {
                    ++this.waveCount;
                    this.resetTimer();
                }
            }
        }
    }

    private void func_221409_a(Entity p_221409_1_) {
        if (this.getWorld().func_217376_c(p_221409_1_)) {
            for (Entity entity : p_221409_1_.func_184188_bt()) {
                this.func_221409_a(entity);
            }
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getWorld().field_73012_v.nextInt(i);
        }
        if (!this.potentialSpawns.isEmpty()) {
            this.setNextSpawnData((SpecialWeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.getWorld().field_73012_v, this.potentialSpawns));
        }
        this.broadcastEvent(1);
    }

    public void read(CompoundNBT nbt) {
        this.spawnDelay = nbt.func_74765_d("Delay");
        this.potentialSpawns.clear();
        if (nbt.func_150297_b("SpawnPotentials", 9)) {
            ListNBT listnbt = nbt.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.potentialSpawns.add(new SpecialWeightedSpawnerEntity(listnbt.func_150305_b(i)));
            }
        }
        if (nbt.func_150297_b("SpawnData", 10)) {
            this.setNextSpawnData(new SpecialWeightedSpawnerEntity(1, nbt.func_74775_l("SpawnData")));
        } else if (!this.potentialSpawns.isEmpty()) {
            this.setNextSpawnData((SpecialWeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.getWorld().field_73012_v, this.potentialSpawns));
        }
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.spawnCount = nbt.func_74765_d("SpawnCount");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (this.getWorld() != null) {
            this.cachedEntity = null;
        }
        this.waveCount = nbt.func_74762_e("WaveCount");
    }

    public CompoundNBT write(CompoundNBT compound) {
        ResourceLocation resourcelocation = this.getEntityId();
        if (resourcelocation != null) {
            compound.func_74777_a("Delay", (short)this.spawnDelay);
            compound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
            compound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
            compound.func_74777_a("SpawnCount", (short)this.spawnCount);
            compound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
            compound.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
            compound.func_74777_a("SpawnRange", (short)this.spawnRange);
            compound.func_218657_a("SpawnData", (INBT)this.spawnData.getNbt().func_74737_b());
            compound.func_74768_a("WaveCount", this.waveCount);
            ListNBT listnbt = new ListNBT();
            if (this.potentialSpawns.isEmpty()) {
                listnbt.add((Object)this.spawnData.toCompoundTag());
            } else {
                for (SpecialWeightedSpawnerEntity weightedspawnerentity : this.potentialSpawns) {
                    listnbt.add((Object)weightedspawnerentity.toCompoundTag());
                }
            }
            compound.func_218657_a("SpawnPotentials", (INBT)listnbt);
        }
        return compound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getCachedEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = EntityType.func_220335_a((CompoundNBT)this.spawnData.getNbt(), (World)this.getWorld(), Function.identity());
            if (this.spawnData.getNbt().func_186856_d() == 1 && this.spawnData.getNbt().func_150297_b("id", 8) && this.cachedEntity instanceof MobEntity) {
                ((MobEntity)this.cachedEntity).func_213386_a((IWorld)this.getWorld(), this.getWorld().func_175649_E(new BlockPos(this.cachedEntity)), SpawnReason.SPAWNER, (ILivingEntityData)null, (CompoundNBT)null);
            }
        }
        return this.cachedEntity;
    }

    public boolean setDelayToMin(int delay) {
        if (delay == 1 && this.getWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    public void setNextSpawnData(SpecialWeightedSpawnerEntity nextSpawnData) {
        this.spawnData = nextSpawnData;
    }

    public abstract void broadcastEvent(int var1);

    public abstract World getWorld();

    public abstract BlockPos getSpawnerPosition();

    @OnlyIn(value=Dist.CLIENT)
    public double getMobRotation() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getPrevMobRotation() {
        return this.prevMobRotation;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }
}

