/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world.structures;

import com.mojang.datafixers.Dynamic;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.world.structures.SmallDungeonPieces;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallDungeonStructure
extends AbstractValhelsiaStructure {
    public static final String SHORT_NAME = "small_dungeon";

    public SmallDungeonStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory, SHORT_NAME);
    }

    @Override
    protected int getFeatureDistance(ChunkGenerator<?> generator) {
        return (Integer)StructureGenConfig.SMALL_DUNGEON_DISTANCE.get();
    }

    @Override
    protected int getFeatureSeparation(ChunkGenerator<?> generator) {
        return (Integer)StructureGenConfig.SMALL_DUNGEON_SEPARATION.get();
    }

    @Override
    protected double getSpawnChance() {
        return (Double)StructureGenConfig.SMALL_DUNGEON_SPAWN_CHANCE.get();
    }

    @Override
    public int func_202367_b() {
        return 3;
    }

    protected int func_202382_c() {
        return 23498567;
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkZ, MutableBoundingBox bounds, int reference, long seed) {
            super(structure, chunkX, chunkZ, bounds, reference, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            SmallDungeonPieces.generate(generator, templateManagerIn, blockpos, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
            this.func_214628_a(generator.func_222530_f(), (Random)this.field_214631_d, 10);
        }
    }
}

