/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.utils.VoxelShapeHelper;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PostBlock
extends RotatedPillarBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty ATTACHED = BooleanProperty.func_177716_a((String)"attached");
    protected static final Map<Direction.Axis, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.Axis.Y, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (Object)Direction.Axis.Z, (Object)Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), (Object)Direction.Axis.X, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));

    public PostBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)ATTACHED) != false ? VoxelShapeHelper.add(0.0, -3.0, 0.0, 0.0, -3.0, 0.0, SHAPES.get(state.func_177229_b((Property)field_176298_M))) : SHAPES.get(state.func_177229_b((Property)field_176298_M));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.shouldAttach(world, pos)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.shouldAttach(world, pos) && !((Boolean)state.func_177229_b((Property)ATTACHED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (!this.shouldAttach(world, pos) && ((Boolean)state.func_177229_b((Property)ATTACHED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(false)), 2);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    private boolean shouldAttach(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP) && world.func_180495_p(pos).func_177229_b((Property)field_176298_M) != Direction.Axis.Y;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ATTACHED, WATERLOGGED, field_176298_M});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

