/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.event;

import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.init.ModStructureFeatures;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BiomeLoadingListener {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerInteractBlock(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        Biome.Category category = event.getCategory();
        if (((List)StructureGenConfig.BLACKLISTED_BIOMES.get()).contains(name.toString())) {
            return;
        }
        if (((Boolean)StructureGenConfig.GENERATE_CASTLES.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.CASTLE_BIOME_CATEGORIES.get(), (List)StructureGenConfig.CASTLE_BIOME_BLACKLIST.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.CASTLE);
        }
        if (((Boolean)StructureGenConfig.GENERATE_CASTLE_RUINS.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.CASTLE_RUIN_BIOME_CATEGORIES.get(), (List)StructureGenConfig.CASTLE_RUIN_BIOME_BLACKLIST.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.CASTLE_RUIN);
        }
        if (((Boolean)StructureGenConfig.GENERATE_FORGES.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.FORGE_BIOME_CATEGORIES.get(), (List)StructureGenConfig.FORGE_BIOME_BLACKLISTS.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.FORGE);
        }
        if (((Boolean)StructureGenConfig.GENERATE_PLAYER_HOUSES.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.PLAYER_HOUSE_BIOME_CATEGORIES.get(), (List)StructureGenConfig.PLAYER_HOUSE_BIOME_BLACKLIST.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.PLAYER_HOUSE);
        }
        if (((Boolean)StructureGenConfig.GENERATE_TOWER_RUINS.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.TOWER_RUIN_BIOME_CATEGORIES.get(), (List)StructureGenConfig.TOWER_RUIN_BIOME_BLACKLIST.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.TOWER_RUIN);
        }
        if (((Boolean)StructureGenConfig.GENERATE_DESERT_HOUSES.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.DESERT_HOUSE_BIOME_CATEGORIES.get(), (List)StructureGenConfig.DESERT_HOUSE_BIOME_BLACKLIST.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.DESERT_HOUSE);
        }
        if (((Boolean)StructureGenConfig.GENERATE_SMALL_DUNGEONS.get()).booleanValue() && BiomeLoadingListener.checkBiome((List)StructureGenConfig.SMALL_DUNGEON_BIOME_CATEGORIES.get(), (List)StructureGenConfig.SMALL_DUNGEON_BIOME_BLACKLIST.get(), name, category)) {
            event.getGeneration().func_242516_a(ModStructureFeatures.SMALL_DUNGEON);
        }
    }

    private static boolean checkBiome(List<? extends Biome.Category> allowedBiomeCategories, List<? extends String> blacklistedBiomes, ResourceLocation name, Biome.Category category) {
        boolean flag;
        boolean bl = flag = allowedBiomeCategories.contains(category.toString()) || allowedBiomeCategories.contains(category);
        if (!blacklistedBiomes.isEmpty() && flag) {
            flag = !blacklistedBiomes.contains(name.toString());
        }
        return flag;
    }
}

