/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.utils.StructureType;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.world.structures.CastleRuinStructure;
import com.stal111.valhelsia_structures.world.structures.CastleStructure;
import com.stal111.valhelsia_structures.world.structures.DesertHouseStructure;
import com.stal111.valhelsia_structures.world.structures.ForgeStructure;
import com.stal111.valhelsia_structures.world.structures.PlayerHouseStructure;
import com.stal111.valhelsia_structures.world.structures.RemovedStructure;
import com.stal111.valhelsia_structures.world.structures.SmallDungeonStructure;
import com.stal111.valhelsia_structures.world.structures.TowerRuinStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModStructures {
    public static final Map<StructureType, List<AbstractValhelsiaStructure>> STRUCTURES_MAP = new HashMap<StructureType, List<AbstractValhelsiaStructure>>();
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"valhelsia_structures");
    public static final RegistryObject<CastleStructure> CASTLE = ModStructures.registerSurfaceStructure(new CastleStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<CastleRuinStructure> CASTLE_RUIN = ModStructures.registerSurfaceStructure(new CastleRuinStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<DesertHouseStructure> DESERT_HOUSE = ModStructures.registerSurfaceStructure(new DesertHouseStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<ForgeStructure> FORGE = ModStructures.registerSurfaceStructure(new ForgeStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<PlayerHouseStructure> PLAYER_HOUSE = ModStructures.registerSurfaceStructure(new PlayerHouseStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<SmallDungeonStructure> SMALL_DUNGEON = ModStructures.registerUndergroundStructure(new SmallDungeonStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<TowerRuinStructure> TOWER_RUIN = ModStructures.registerSurfaceStructure(new TowerRuinStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<RemovedStructure> SMALL_CASTLE = ModStructures.registerSurfaceStructure(new RemovedStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_, "small_castle"));

    private static <T extends AbstractValhelsiaStructure> RegistryObject<T> registerSurfaceStructure(T structure) {
        return ModStructures.register(structure.getName(), structure, GenerationStage.Decoration.SURFACE_STRUCTURES);
    }

    private static <T extends AbstractValhelsiaStructure> RegistryObject<T> registerUndergroundStructure(T structure) {
        return ModStructures.register(structure.getName(), structure, GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
    }

    private static <T extends AbstractValhelsiaStructure> RegistryObject<T> register(String name, T structure, GenerationStage.Decoration decoration) {
        Structure.field_236365_a_.put((Object)("valhelsia_structures:" + name), structure);
        Structure.field_236385_u_.put(structure, decoration);
        if (decoration != GenerationStage.Decoration.UNDERGROUND_STRUCTURES) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        STRUCTURES_MAP.computeIfAbsent(structure.getStructureType(), k -> new ArrayList());
        STRUCTURES_MAP.get((Object)structure.getStructureType()).add(structure);
        return STRUCTURES.register(name, () -> structure);
    }
}

