/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureUtils {
    public static Direction getRandomDir(Random rand) {
        return Direction.func_176731_b((int)rand.nextInt(4));
    }

    public static int getLowestHeight(IWorld world, int x, int z, int xSize, int zSize) {
        int h0 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
        int h1 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x + xSize, z);
        int h2 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z + zSize);
        int h3 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x + xSize, z + zSize);
        return Math.min(Math.min(h0, h1), Math.min(h2, h3));
    }

    public static BlockPos getSurfaceStructurePosition(@Nonnull ChunkGenerator generator, int size, Rotation rotation, int chunkX, int chunkZ) {
        int xOffset = size * 16;
        int zOffset = size * 16;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        return new BlockPos(x + xOffset / 2, 0, z + zOffset / 2);
    }

    public static boolean checkForOtherStructures(Structure<?> structure, ChunkGenerator generator, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, List<Structure<?>> structures) {
        for (int k = chunkX - 5; k <= chunkX + 5; ++k) {
            for (int l = chunkZ - 5; l <= chunkZ + 5; ++l) {
                for (Structure<?> structure1 : structures) {
                    if (structure == structure1) continue;
                    ChunkPos structurePos = structure1.func_236392_a_(Objects.requireNonNull(generator.func_235957_b_().func_236197_a_(structure1)), seed, rand, k, l);
                    if (k != structurePos.field_77276_a || l != structurePos.field_77275_b) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static List<String> getAllBiomesForCategory(Biome.Category ... categories) {
        ArrayList<String> biomes = new ArrayList<String>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            for (Biome.Category category : categories) {
                if (biome.func_201856_r() != category) continue;
                biomes.add(Objects.requireNonNull(biome.getRegistryName()).toString());
            }
        }
        return biomes;
    }
}

