/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.commands;

import com.matez.wildnature.Main;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class PageableMessage {
    private ArrayList<String> lines;
    private ArrayList<ArrayList<String>> pages = new ArrayList();
    private int linesPerPage;
    private int allLines;
    private ArrayList<String> page;
    private String startString;
    private String endString;
    private String prefix;

    public PageableMessage(ArrayList<String> lines, int linesPerPage, String startString, String endString, String prefix) {
        this.lines = lines;
        this.linesPerPage = linesPerPage;
        this.startString = startString;
        this.endString = endString;
        this.prefix = prefix;
        int curr = 0;
        for (int a = 0; a < lines.size(); ++a) {
            if (curr >= linesPerPage) {
                curr = 0;
                ++this.allLines;
                this.pages.add(this.page);
            }
            if (curr == 0) {
                this.page = new ArrayList();
            }
            this.page.add(lines.get(a));
            ++curr;
        }
        if (curr != 0) {
            ++this.allLines;
            this.pages.add(this.page);
        }
    }

    public int getAllLines() {
        return this.allLines;
    }

    public void setStartString(String string) {
        this.startString = string;
    }

    public void setEndString(String string) {
        this.endString = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void show(EntityPlayer player, int page) {
        if (page > this.allLines || page < 1) {
            throw new ArrayIndexOutOfBoundsException("Page not found");
        }
        if (!this.startString.isEmpty()) {
            Main.sendMessage(player, this.startString);
        }
        try {
            for (int a = 0; a < this.pages.get(page - 1).size(); ++a) {
                String pfx = this.prefix.replace("<$line>", a * this.pages.indexOf(this.pages.get(page - 1)) + "");
                Main.sendMessage(player, pfx + this.pages.get(page - 1).get(a));
            }
        }
        catch (IndexOutOfBoundsException e) {
            Main.sendMessage(player, this.prefix.replace("<$line>", "#") + " ");
        }
        if (!this.endString.isEmpty()) {
            Main.sendMessage(player, this.endString);
        }
    }
}

