/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import com.matez.wildnature.Main;
import com.matez.wildnature.init.ModBlocks;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenSchematicLeaves
extends WorldGenAbstractTree {
    public IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    public IBlockState LEAVES = ModBlocks.FIR_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    public IBlockState FLOOR = Blocks.field_150350_a.func_176223_P();
    private final int minTreeHeight = 15;
    World world;
    BlockPos pos;
    int rotate;
    ArrayList<BlockPos> addedBlocks = new ArrayList();
    ArrayList<BlockPos> bottomBlocks = new ArrayList();
    int doneBlocks = 0;
    public boolean canRotate = true;
    public boolean spawnVines = false;
    public int vineChance = 4;

    public WorldGenSchematicLeaves(boolean parShouldNotify, @Nullable IBlockState leavesState) {
        super(parShouldNotify);
        if (leavesState != null) {
            this.LEAVES = leavesState;
        }
    }

    public WorldGenSchematicLeaves(boolean parShouldNotify, @Nullable IBlockState leavesState, boolean canRotate) {
        super(parShouldNotify);
        if (leavesState != null) {
            this.LEAVES = leavesState;
        }
        this.canRotate = canRotate;
    }

    public void spawnVines(ArrayList<BlockPos> leaves, World world, Random random) {
        if (this.spawnVines) {
            int y = 0;
            for (int x = 0; x < leaves.size(); ++x) {
                int chance = Main.generateRandomInt(1, this.vineChance, random);
                if (chance != 1) continue;
                do {
                    int a;
                    BlockPos vinePos;
                    int vineFacing = Main.generateRandomInt(1, 4, random);
                    ++y;
                    if (vineFacing == 1) {
                        vinePos = leaves.get(x).func_177978_c();
                        a = 0;
                        while (world.func_175623_d(vinePos.func_177979_c(a))) {
                            this.func_175903_a(world, vinePos.func_177979_c(a), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)));
                            ++a;
                        }
                    } else if (vineFacing == 2) {
                        vinePos = leaves.get(x).func_177968_d();
                        a = 0;
                        while (world.func_175623_d(vinePos.func_177979_c(a))) {
                            this.func_175903_a(world, vinePos.func_177979_c(a), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)));
                            ++a;
                        }
                    } else if (vineFacing == 3) {
                        vinePos = leaves.get(x).func_177974_f();
                        a = 0;
                        while (world.func_175623_d(vinePos.func_177979_c(a))) {
                            this.func_175903_a(world, vinePos.func_177979_c(a), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)));
                            ++a;
                        }
                    } else {
                        if (vineFacing != 4) continue;
                        vinePos = leaves.get(x).func_177976_e();
                        a = 0;
                        while (world.func_175623_d(vinePos.func_177979_c(a))) {
                            this.func_175903_a(world, vinePos.func_177979_c(a), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)));
                            ++a;
                        }
                    }
                } while (y != 4);
                y = 0;
            }
        }
    }

    public boolean func_180709_b(World parWorld, Random parRandom, BlockPos parBlockPos) {
        this.world = parWorld;
        this.pos = parBlockPos;
        this.rotate = this.canRotate ? Main.generateRandomInt(1, 4, parRandom) : 1;
        this.addedBlocks.clear();
        this.generateBlocks(parWorld, parBlockPos, 0, parRandom);
        this.spawnVines(this.addedBlocks, parWorld, parRandom);
        return true;
    }

    public void generatePlatform(World world) {
        int x;
        BlockPos down = null;
        for (x = 0; x < this.addedBlocks.size(); ++x) {
            if (down == null) {
                down = this.addedBlocks.get(x);
            }
            if (this.addedBlocks.get(x).func_177956_o() >= down.func_177956_o()) continue;
            down = this.addedBlocks.get(x);
        }
        for (x = 0; x < this.addedBlocks.size(); ++x) {
            if (this.addedBlocks.get(x).func_177956_o() != down.func_177956_o() + 1) continue;
            this.bottomBlocks.add(this.downBlock(this.addedBlocks.get(x), 1));
        }
        x = 0;
        int loop = 0;
        int done = 0;
        while (true) {
            if (world.func_175623_d(this.downBlock(this.bottomBlocks.get(x), loop))) {
                this.func_175903_a(world, this.downBlock(this.bottomBlocks.get(x), loop), this.FLOOR);
            } else {
                ++done;
            }
            if (this.bottomBlocks.size() - 1 == x) {
                x = 0;
                ++loop;
                done = 0;
            }
            if (loop == 10) break;
            ++x;
        }
    }

    private BlockPos downBlock(BlockPos blockPos, int down) {
        return new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() - down, blockPos.func_177952_p());
    }

    public void generateBlocks(World parWorld, BlockPos parBlockPos, int height, Random parRandom) {
        System.out.println("Nothing happens");
    }

    public void Block(int x, int y, int z, IBlockState blockState) {
        --y;
        BlockPos posx = null;
        if (this.rotate == 1) {
            posx = new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
        } else if (this.rotate == 2) {
            posx = new BlockPos(this.pos.func_177958_n() - x, this.pos.func_177956_o() + y, this.pos.func_177952_p() - z);
        } else if (this.rotate == 3) {
            posx = new BlockPos(this.pos.func_177958_n() - x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
        } else if (this.rotate == 4) {
            posx = new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() - z);
        } else {
            throw new NullPointerException("Rotation is " + this.rotate + ", but allowed is from 1 to 4");
        }
        this.func_175903_a(this.world, posx, blockState);
        this.addedBlocks.add(posx);
    }

    private boolean isSuitableLocation(World parWorld, BlockPos parBlockPos, int minHeight) {
        boolean isSuitableLocation = true;
        if (!parWorld.func_180495_p(parBlockPos.func_177977_b()).func_185913_b()) {
            return false;
        }
        for (int checkY = parBlockPos.func_177956_o(); checkY <= parBlockPos.func_177956_o() + 1 + minHeight; ++checkY) {
            int extraSpaceNeeded = 1;
            if (checkY == parBlockPos.func_177956_o()) {
                extraSpaceNeeded = 0;
            }
            if (checkY >= parBlockPos.func_177956_o() + 1 + minHeight - 2) {
                extraSpaceNeeded = 2;
            }
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int checkX = parBlockPos.func_177958_n() - extraSpaceNeeded; checkX <= parBlockPos.func_177958_n() + extraSpaceNeeded && isSuitableLocation; ++checkX) {
                for (int checkZ = parBlockPos.func_177952_p() - extraSpaceNeeded; checkZ <= parBlockPos.func_177952_p() + extraSpaceNeeded && isSuitableLocation; ++checkZ) {
                    isSuitableLocation = this.isReplaceable(parWorld, (BlockPos)blockPos.func_181079_c(checkX, checkY, checkZ));
                }
            }
        }
        return isSuitableLocation;
    }
}

