/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.biomes;

import com.matez.wildnature.Main;
import com.matez.wildnature.entity.EntityBoar;
import com.matez.wildnature.entity.EntityDuckChild;
import com.matez.wildnature.entity.EntityDuckFemale;
import com.matez.wildnature.entity.EntityDuckMale;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.BigTree;
import com.matez.wildnature.worldgen.biomes.BiomeDecorator1;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class BiomeAutumnalForest
extends Biome {
    private static final IBlockState LOG1 = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private static final IBlockState LOG2 = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK);
    private static final IBlockState LOG3 = ModBlocks.ROTTEN_LOG.func_176223_P();
    private static final IBlockState LEAVESRED = ModBlocks.RED_AUTUMN.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    private static final IBlockState LEAVESORANGE = ModBlocks.ORANGE_AUTUMN.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    private static final IBlockState LEAVESYELLOW = ModBlocks.YELLOW_AUTUMN.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    private static final IBlockState LEAVESROTTEN = ModBlocks.ROTTEN_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    private static final IBlockState LEAVESOAK = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));

    public BiomeAutumnalForest() {
        super(new Biome.BiomeProperties("Autumnal Forest").func_185398_c(0.2f).func_185400_d(0.15f).func_185410_a(0.4f).func_185395_b(0.7f));
    }

    public int func_180627_b(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeGrassColor(noise < -0.1 ? 11909458 : 12159321);
    }

    public int func_180625_c(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeGrassColor(noise < -0.1 ? 10724903 : 3054616);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        IBlockState LOG = null;
        IBlockState LEAVES = null;
        int x = Main.generateRandomInt(1, 6, rand);
        LOG = x <= 2 ? LOG1 : (x <= 5 ? LOG2 : LOG3);
        x = Main.generateRandomInt(1, 5, rand);
        LEAVES = x == 1 ? LEAVESRED : (x == 2 ? LEAVESORANGE : (x == 3 ? LEAVESYELLOW : (x == 4 ? LEAVESOAK : LEAVESROTTEN)));
        x = Main.generateRandomInt(1, 3, rand);
        Object TREE = null;
        TREE = x == 1 ? new BigTree(true, 8, 1, 1.0, LOG, LEAVES, Blocks.field_150345_g.func_176223_P()) : new WorldGenTrees(true, 5, LOG, LEAVES, false);
        return TREE;
    }

    public BiomeDecorator func_76729_a() {
        BiomeDecorator1 decorator = new BiomeDecorator1();
        this.field_76752_A = ModBlocks.MOLD_GRASS_BLOCK.func_176223_P();
        this.field_76753_B = ModBlocks.ZIEMA_CZARNOZIEM.func_176223_P();
        decorator.field_76832_z = 6;
        decorator.field_76803_B = 20;
        decorator.field_76805_H = 0;
        decorator.field_76801_G = 8;
        decorator.flowers.clear();
        decorator.flowers.add(ModBlocks.DEAD_LEAF_PILE.func_176223_P(), 10);
        decorator.flowers.add(ModBlocks.LEAF_PILE.func_176223_P(), 3);
        decorator.flowers.add(ModBlocks.CLOVER.func_176223_P(), 5);
        decorator.flowers.add(ModBlocks.WRZOS.func_176223_P(), 3);
        decorator.flowers.add(ModBlocks.WRZOS_PINK.func_176223_P(), 3);
        decorator.flowers.add(ModBlocks.WRZOS_WHITE.func_176223_P(), 3);
        decorator.mushrooms.add(ModBlocks.BOROWIK_SZLACHETNY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.BOROWIK_WYSMUKLY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.KOZLARZ_CZERWONY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MASLAK_ZWYCZAJNY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MLECZAJ_RYDZ.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MUCHOMOR_SROMOTNIKOWY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MUCHOMOR_JADOWITY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.PIEPRZNIK_JADALNY.func_176223_P());
        decorator.field_76802_A = 30;
        return this.getModdedBiomeDecorator(decorator);
    }

    public void addDefaultFlowers() {
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 7, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 7, 3, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckMale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckFemale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckChild.class, 1, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityBoar.class, 3, 1, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 1, 3, 5));
    }
}

