/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.biomes;

import com.matez.wildnature.Main;
import com.matez.wildnature.entity.EntityBoar;
import com.matez.wildnature.entity.EntityDuckChild;
import com.matez.wildnature.entity.EntityDuckFemale;
import com.matez.wildnature.entity.EntityDuckMale;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.biomes.BiomeDecorator1;
import com.matez.wildnature.worldgen.schematics.trees.birch.treeGen_birch1;
import com.matez.wildnature.worldgen.schematics.trees.birch.treeGen_birch10;
import com.matez.wildnature.worldgen.schematics.trees.birch.treeGen_birch11;
import com.matez.wildnature.worldgen.schematics.trees.birch.treeGen_birch12;
import com.matez.wildnature.worldgen.schematics.trees.birch.treeGen_birch2;
import com.matez.wildnature.worldgen.schematics.trees.birch.treeGen_birch7;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;

public class BiomeMasuria
extends Biome {
    public static IBlockState LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    public static IBlockState LEAVES = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    public static IBlockState DARKLOG = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK);
    public static IBlockState DARKLEAVES = Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    public static IBlockState BIRCHLOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
    public static IBlockState BIRCHLEAVES = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    protected static WorldGenAbstractTree TREE1;
    protected static WorldGenAbstractTree TREE2;
    protected static WorldGenAbstractTree TREE3;
    protected static WorldGenAbstractTree TREE4;
    protected static WorldGenAbstractTree TREE5;
    protected static WorldGenAbstractTree TREE6;
    protected static WorldGenAbstractTree TREE7;
    protected static WorldGenAbstractTree TREE8;
    protected static WorldGenAbstractTree TREE9;
    protected static WorldGenAbstractTree TREE10;
    protected static WorldGenAbstractTree TREE11;
    protected static WorldGenAbstractTree TREE;
    public ArrayList<BlockPos> posArrayList = new ArrayList();

    public BiomeMasuria() {
        super(new Biome.BiomeProperties("Masuria").func_185398_c(0.01f).func_185400_d(0.0f).func_185410_a(0.5f).func_185395_b(0.8f));
    }

    public int getWaterColorMultiplier() {
        return 33737;
    }

    public int func_180627_b(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeGrassColor(noise < -0.1 ? 7128337 : 9291095);
    }

    public int func_180625_c(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeFoliageColor(noise < -0.1 ? 6663238 : 8105023);
    }

    public int func_76731_a(float currentTemperature) {
        return 11070440;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        TREE = new WorldGenBigTree(true);
        TREE1 = new treeGen_birch10(true, LOG, LEAVES);
        TREE2 = new treeGen_birch1(true, LOG, LEAVES);
        TREE4 = new treeGen_birch10(true, DARKLOG, DARKLEAVES);
        TREE5 = new treeGen_birch1(true, DARKLOG, DARKLEAVES);
        TREE6 = new treeGen_birch1(true, BIRCHLOG, BIRCHLEAVES);
        TREE7 = new treeGen_birch2(true, BIRCHLOG, BIRCHLEAVES);
        TREE8 = new treeGen_birch7(true, BIRCHLOG, BIRCHLEAVES);
        TREE9 = new treeGen_birch10(true, BIRCHLOG, BIRCHLEAVES);
        TREE10 = new treeGen_birch11(true, BIRCHLOG, BIRCHLEAVES);
        TREE11 = new treeGen_birch12(true, BIRCHLOG, BIRCHLEAVES);
        switch (Main.generateRandomInt(0, 4)) {
            case 0: {
                return TREE;
            }
            case 1: {
                switch (Main.generateRandomInt(0, 1)) {
                    case 0: {
                        return TREE1;
                    }
                    case 1: {
                        return TREE2;
                    }
                }
            }
            case 2: {
                switch (Main.generateRandomInt(0, 1)) {
                    case 0: {
                        return TREE4;
                    }
                    case 1: {
                        return TREE5;
                    }
                }
            }
            case 3: {
                switch (Main.generateRandomInt(0, 5)) {
                    case 0: {
                        return TREE6;
                    }
                    case 1: {
                        return TREE7;
                    }
                    case 2: {
                        return TREE8;
                    }
                    case 3: {
                        return TREE9;
                    }
                    case 4: {
                        return TREE10;
                    }
                    case 5: {
                        return TREE11;
                    }
                }
            }
        }
        return TREE;
    }

    public BiomeDecorator func_76729_a() {
        BiomeDecorator1 decorator = new BiomeDecorator1();
        this.field_76752_A = ModBlocks.MOLD_GRASS_BLOCK.func_176223_P();
        this.field_76753_B = ModBlocks.ZIEMA_CZARNOZIEM.func_176223_P();
        decorator.field_76832_z = 3;
        decorator.field_76803_B = 12;
        decorator.field_76805_H = 8;
        decorator.field_76806_I = 9;
        decorator.flowers.clear();
        decorator.flowers.add(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA), 5);
        decorator.flowers.add(ModBlocks.CLOVER.func_176223_P(), 7);
        decorator.flowers.add(ModBlocks.LEAF_PILE.func_176223_P(), 8);
        decorator.flowers.add(ModBlocks.DZWONECZEK.func_176223_P(), 2);
        decorator.field_76802_A = 12;
        return this.getModdedBiomeDecorator(decorator);
    }

    public void addDefaultFlowers() {
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 7, 3, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityBoar.class, 2, 1, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckMale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckFemale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckChild.class, 1, 1, 2));
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        if (!(noiseVal > 1.55) && noiseVal > -1.25) {
            this.field_76752_A = Blocks.field_150355_j.func_176223_P();
            this.field_76753_B = Blocks.field_150358_i.func_176223_P();
        }
        this.generateTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public final void generateTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                j = k;
                if (j1 > 67 && iblockstate.equals(Blocks.field_150355_j.func_176223_P())) {
                    iblockstate = Blocks.field_150349_c.func_176223_P();
                }
                if (j1 >= i - 1) {
                    if (iblockstate.func_177230_c().equals(Blocks.field_150355_j) || iblockstate.func_177230_c().equals(Blocks.field_150358_i)) {
                        int g = Main.generateRandomInt(1, 2);
                        switch (g) {
                            case 1: {
                                chunkPrimerIn.func_177855_a(i1, j1, l, Blocks.field_150349_c.func_176223_P());
                            }
                            case 2: {
                                this.setRiver(new BlockPos(i1, j1, l), chunkPrimerIn, this.field_76752_A, worldIn);
                            }
                        }
                        continue;
                    }
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    chunkPrimerIn.func_177855_a(i1, j1, l, field_185368_d);
                    continue;
                }
                this.setRiver(new BlockPos(i1, j1, l), chunkPrimerIn, iblockstate1, worldIn);
                continue;
            }
            if (j <= 0) continue;
            this.setRiver(new BlockPos(i1, j1, l), chunkPrimerIn, iblockstate1, worldIn);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
        }
    }

    public void setRiver(BlockPos pos, ChunkPrimer chunkPrimer, IBlockState blockState, World world) {
        if (blockState == Blocks.field_150355_j.func_176223_P() || blockState == Blocks.field_150358_i.func_176223_P()) {
            if (pos.func_177956_o() <= world.func_181545_F() - 1) {
                if (pos.func_177956_o() > 0 && pos.func_177956_o() + 3 >= world.func_181545_F() - 1) {
                    int a;
                    for (a = 0; a < 5; ++a) {
                        chunkPrimer.func_177855_a(pos.func_177958_n(), pos.func_177956_o() - a, pos.func_177952_p(), Blocks.field_150355_j.func_176223_P());
                    }
                    chunkPrimer.func_177855_a(pos.func_177958_n(), pos.func_177956_o() - a, pos.func_177952_p(), Blocks.field_150346_d.func_176223_P());
                }
            } else {
                chunkPrimer.func_177855_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Blocks.field_150350_a.func_176223_P());
                this.posArrayList.add(pos);
            }
        }
    }
}

