/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.biomes;

import com.matez.wildnature.Main;
import com.matez.wildnature.entity.EntityBoar;
import com.matez.wildnature.entity.EntityDuckChild;
import com.matez.wildnature.entity.EntityDuckFemale;
import com.matez.wildnature.entity.EntityDuckMale;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.biomes.BiomeDecorator1;
import com.matez.wildnature.worldgen.schematics.trees.redwood.treeGen_redwood1;
import com.matez.wildnature.worldgen.schematics.trees.redwood.treeGen_redwood2;
import com.matez.wildnature.worldgen.schematics.trees.redwood.treeGen_redwood3;
import com.matez.wildnature.worldgen.schematics.trees.redwood.treeGen_redwood4;
import com.matez.wildnature.worldgen.world.MBBiome;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;

public class BiomeRedwoodForest
extends MBBiome {
    private static final IBlockState LOG = ModBlocks.REDWOOD_LOG.func_176223_P();
    private static final IBlockState LEAVES = ModBlocks.REDWOOD_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));

    public BiomeRedwoodForest() {
        super(new Biome.BiomeProperties("Redwood Forest").func_185399_a("deciduous_forest").func_185398_c(0.1f).func_185400_d(0.07f).func_185410_a(0.4f).func_185395_b(0.6f));
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        int x = Main.generateRandomInt(0, 22, rand);
        if (x < 16) {
            if (Main.generateRandomInt(0, 2) == 0) {
                return new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P());
            }
            return new WorldGenShrub(LOG, LEAVES);
        }
        switch (Main.generateRandomInt(1, 4, rand)) {
            case 1: {
                return new treeGen_redwood1(true, LOG, LEAVES);
            }
            case 2: {
                return new treeGen_redwood2(true, LOG, LEAVES);
            }
            case 3: {
                return new treeGen_redwood3(true, LOG, LEAVES);
            }
            case 4: {
                return new treeGen_redwood4(true, LOG, LEAVES);
            }
        }
        return null;
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
    }

    public BiomeDecorator func_76729_a() {
        BiomeDecorator1 decorator = new BiomeDecorator1();
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        decorator.field_76832_z = 11;
        decorator.field_76803_B = 10;
        decorator.field_76805_H = 5;
        decorator.field_76806_I = 2;
        decorator.field_76799_E = 4;
        decorator.mushrooms.add(ModBlocks.BOROWIK_SZLACHETNY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.BOROWIK_WYSMUKLY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.KOZLARZ_CZERWONY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MASLAK_ZWYCZAJNY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MLECZAJ_RYDZ.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MUCHOMOR_SROMOTNIKOWY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MUCHOMOR_JADOWITY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.PIEPRZNIK_JADALNY.func_176223_P());
        decorator.field_76802_A = 20;
        return this.getModdedBiomeDecorator(decorator);
    }

    public void addDefaultFlowers() {
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 7, 3, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityBoar.class, 2, 1, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckMale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckFemale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckChild.class, 1, 1, 2));
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        if (noiseVal > 1.75) {
            this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
        } else if (noiseVal > -0.95) {
            this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        }
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }
}

